/*
 * Decompiled with CFR 0.152.
 */
package io.agora.utils.crypto;

import android.util.Base64;
import android.util.Log;
import io.agora.utils.crypto.AsymmetricKeyPair;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.KeyFactory;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;

public class Asymmetric {
    protected static final char[] hexArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public long Encrypt(String string, AsymmetricKeyPair asymmetricKeyPair, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        if (asymmetricKeyPair == null) {
            return 0L;
        }
        return this.CipherOperation(string, 1, asymmetricKeyPair.getPublicKey(), asymmetricKeyPair.GetKeyLenBits() / 8L, byteBuffer, byteBuffer2);
    }

    public long Decrypt(String string, AsymmetricKeyPair asymmetricKeyPair, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        if (asymmetricKeyPair == null) {
            return 0L;
        }
        return this.CipherOperation(string, 2, asymmetricKeyPair.getPrivateKey(), asymmetricKeyPair.GetKeyLenBits() / 8L, byteBuffer, byteBuffer2);
    }

    private long CipherOperation(String string, int n, Key key, long l, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        if (key == null || byteBuffer == null || !byteBuffer.hasRemaining()) {
            return 0L;
        }
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(string);
        }
        catch (Exception exception) {
            return 0L;
        }
        if (cipher == null) {
            return 0L;
        }
        try {
            cipher.init(n, key);
            return cipher.doFinal(byteBuffer, byteBuffer2);
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public long ShareSecret(String string, AsymmetricKeyPair asymmetricKeyPair, AsymmetricKeyPair asymmetricKeyPair2, ByteBuffer byteBuffer) {
        if (asymmetricKeyPair == null || asymmetricKeyPair2 == null || asymmetricKeyPair.getPrivateKey() == null || asymmetricKeyPair2.getPublicKey() == null) {
            return 0L;
        }
        try {
            KeyAgreement keyAgreement = KeyAgreement.getInstance(string);
            if (keyAgreement == null) {
                return 0L;
            }
            keyAgreement.init(asymmetricKeyPair.getPrivateKey());
            keyAgreement.doPhase(asymmetricKeyPair2.getPublicKey(), true);
            byte[] byArray = keyAgreement.generateSecret();
            if (byteBuffer.remaining() >= byArray.length) {
                byteBuffer.put(byArray);
            }
            return byArray.length;
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    private static byte[] GetFromBigInteger(BigInteger bigInteger) {
        String string = bigInteger.toString(16);
        int n = string.length();
        if (n % 2 != 0) {
            string = "0" + string;
            n = string.length();
        }
        byte[] byArray = new byte[n / 2];
        for (int i = 0; i < n; i += 2) {
            byArray[i / 2] = (byte)((Character.digit(string.charAt(i), 16) << 4) + Character.digit(string.charAt(i + 1), 16));
        }
        return byArray;
    }

    private static BigInteger GetFromByteArray(byte[] byArray) {
        char[] cArray = new char[byArray.length * 2];
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            cArray[i * 2] = hexArray[n >>> 4];
            cArray[i * 2 + 1] = hexArray[n & 0xF];
        }
        String string = new String(cArray);
        BigInteger bigInteger = new BigInteger(string, 16);
        return bigInteger;
    }

    public static ByteBuffer ECCPublicKeyDerToAsn(String string) {
        Object object;
        if (string == null || string.isEmpty()) {
            return null;
        }
        X509EncodedKeySpec x509EncodedKeySpec = null;
        try {
            string = string.replace("\r\n", "");
            string = string.replace("\n", "");
            object = Base64.decode((String)string, (int)0);
            x509EncodedKeySpec = new X509EncodedKeySpec((byte[])object);
        }
        catch (Exception exception) {
            Log.e((String)"Asymmetric", (String)("ECCPublicKeyDerToAsn: Base64Decode failed:\n\t" + exception.getMessage()));
            return null;
        }
        object = null;
        try {
            ECPublicKey eCPublicKey = null;
            KeyFactory keyFactory = KeyFactory.getInstance("EC");
            eCPublicKey = (ECPublicKey)keyFactory.generatePublic(x509EncodedKeySpec);
            byte[] byArray = Asymmetric.GetFromBigInteger(eCPublicKey.getW().getAffineX());
            byte[] byArray2 = Asymmetric.GetFromBigInteger(eCPublicKey.getW().getAffineY());
            object = ByteBuffer.allocateDirect(1 + byArray.length + byArray2.length);
            ((ByteBuffer)object).put((byte)4);
            ((ByteBuffer)object).put(byArray);
            ((ByteBuffer)object).put(byArray2);
        }
        catch (Exception exception) {
            Log.e((String)"Asymmetric", (String)("ECCPublicKeyDerToAsn: Export public key failed:\n\t" + exception.getMessage()));
            return null;
        }
        return object;
    }

    public static String ECCPublicKeyAsnToDer(ByteBuffer byteBuffer) {
        Object object;
        byte by = byteBuffer.get();
        if (by != 4) {
            Log.e((String)"Asymmetric", (String)("ECCPublicKeyAsnToDer: Import public key failed, first byte must be 0x04 but we got " + by));
            return "";
        }
        byte[] byArray = new byte[byteBuffer.remaining() / 2];
        byte[] byArray2 = new byte[byteBuffer.remaining() / 2];
        byteBuffer.get(byArray);
        byteBuffer.get(byArray2);
        long l = byArray.length * 8;
        l = l < 256L ? 0L : (l < 384L ? 256L : (l < 512L ? 384L : 521L));
        ECPublicKey eCPublicKey = null;
        try {
            String string;
            object = Asymmetric.GetFromByteArray(byArray);
            BigInteger bigInteger = Asymmetric.GetFromByteArray(byArray2);
            ECPoint eCPoint = new ECPoint((BigInteger)object, bigInteger);
            if (l == 256L) {
                string = "secp256r1";
            } else if (l == 384L) {
                string = "secp384r1";
            } else if (l == 521L) {
                string = "secp521r1";
            } else {
                return "";
            }
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("EC");
            algorithmParameters.init(new ECGenParameterSpec(string));
            ECParameterSpec eCParameterSpec = algorithmParameters.getParameterSpec(ECParameterSpec.class);
            ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(eCPoint, eCParameterSpec);
            KeyFactory keyFactory = KeyFactory.getInstance("EC");
            eCPublicKey = (ECPublicKey)keyFactory.generatePublic(eCPublicKeySpec);
        }
        catch (Exception exception) {
            Log.e((String)"Asymmetric", (String)("ECCPublicKeyAsnToDer: Import public key failed:\n\t" + exception.getMessage()));
            return "";
        }
        object = null;
        try {
            object = eCPublicKey.getEncoded();
        }
        catch (Exception exception) {
            Log.e((String)"Asymmetric", (String)("ECCPublicKeyAsnToDer: Import public key failed:\n\t" + exception.getMessage()));
        }
        if (object == null) {
            return "";
        }
        return new String(Base64.encode((byte[])object, (int)2));
    }
}

