/*
 * Decompiled with CFR 0.152.
 */
package io.agora.utils.crypto;

import android.util.Base64;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;

public class AsymmetricKeyPair {
    private PrivateKey priv_key_ = null;
    private PublicKey pub_key_ = null;
    private String name_ = null;
    private long key_len_bits_ = 0L;

    public void SetKeyPair(PrivateKey privateKey, PublicKey publicKey) {
        this.priv_key_ = privateKey;
        this.pub_key_ = publicKey;
        this.ResetKeyProperties();
    }

    public boolean GenerateKeyPair(String string, long l) {
        KeyPairGenerator keyPairGenerator = null;
        try {
            keyPairGenerator = KeyPairGenerator.getInstance(string);
        }
        catch (Exception exception) {
            return false;
        }
        keyPairGenerator.initialize((int)l);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        if (keyPair == null) {
            return false;
        }
        this.priv_key_ = keyPair.getPrivate();
        this.pub_key_ = keyPair.getPublic();
        this.name_ = string;
        this.key_len_bits_ = l;
        return true;
    }

    public long GetKeyLenBits() {
        return this.key_len_bits_;
    }

    public boolean ImportPublicKey(String string, String string2) {
        Object object;
        this.priv_key_ = null;
        this.pub_key_ = null;
        this.key_len_bits_ = 0L;
        if (string2 == null || string2.isEmpty()) {
            return false;
        }
        X509EncodedKeySpec x509EncodedKeySpec = null;
        try {
            object = Base64.decode((String)string2, (int)0);
            x509EncodedKeySpec = new X509EncodedKeySpec((byte[])object);
        }
        catch (Exception exception) {
            return false;
        }
        try {
            object = KeyFactory.getInstance(string);
            this.pub_key_ = ((KeyFactory)object).generatePublic(x509EncodedKeySpec);
            this.priv_key_ = null;
        }
        catch (Exception exception) {
            return false;
        }
        this.name_ = string;
        this.ResetKeyProperties();
        return true;
    }

    private void ResetKeyProperties() {
        this.key_len_bits_ = 0L;
        if (this.pub_key_ instanceof RSAPublicKey) {
            this.key_len_bits_ = ((RSAPublicKey)this.pub_key_).getModulus().toByteArray().length * 8;
            this.key_len_bits_ = this.key_len_bits_ < 512L ? 256L : (this.key_len_bits_ < 1024L ? 512L : (this.key_len_bits_ < 2048L ? 1024L : (this.key_len_bits_ < 3172L ? 2048L : (this.key_len_bits_ < 4096L ? 3172L : (this.key_len_bits_ < 8192L ? 4096L : 8192L)))));
            this.name_ = "RSA";
        } else if (this.pub_key_ instanceof ECPublicKey) {
            this.key_len_bits_ = ((ECPublicKey)this.pub_key_).getW().getAffineX().toByteArray().length * 8;
            this.key_len_bits_ = this.key_len_bits_ < 256L ? 0L : (this.key_len_bits_ < 384L ? 256L : (this.key_len_bits_ < 512L ? 384L : 521L));
            this.name_ = "EC";
        }
    }

    public String ExportPublicKey() {
        if (this.pub_key_ == null) {
            return "";
        }
        byte[] byArray = null;
        try {
            byArray = this.pub_key_.getEncoded();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (byArray == null) {
            return "";
        }
        return new String(Base64.encode((byte[])byArray, (int)2));
    }

    public PublicKey getPublicKey() {
        return this.pub_key_;
    }

    public PrivateKey getPrivateKey() {
        return this.priv_key_;
    }
}

