/*
 * Decompiled with CFR 0.152.
 */
package io.agora.utils.crypto;

import android.util.Base64;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import javax.crypto.Mac;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;

public class CommonUtils {
    private static Boolean mSystemCryptoSupport = null;

    public static void GeneratorRandom(ByteBuffer byteBuffer) {
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray = new byte[byteBuffer.remaining()];
        secureRandom.nextBytes(byArray);
        byteBuffer.put(byArray);
    }

    public static String Base64Encode(ByteBuffer byteBuffer) {
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byArray);
        return Base64.encodeToString((byte[])byArray, (int)2);
    }

    public static byte[] Base64Decode(String string) {
        String string2 = string.replace("\r\n", "");
        string2 = string2.replace("\n", "");
        return Base64.decode((String)string2, (int)0);
    }

    private static void pbkdf2F(Mac mac, byte[] byArray, byte[] byArray2, int n, byte[] byArray3, byte[] byArray4, int n2) throws ShortBufferException {
        if (n == 0) {
            throw new IllegalArgumentException("iteration count must be at least 1.");
        }
        if (byArray2 != null) {
            mac.update(byArray2, 0, byArray2.length);
        }
        mac.update(byArray3, 0, byArray3.length);
        mac.doFinal(byArray, 0);
        System.arraycopy(byArray, 0, byArray4, n2, byArray.length);
        for (int i = 1; i < n; ++i) {
            mac.update(byArray, 0, byArray.length);
            mac.doFinal(byArray, 0);
            for (int j = 0; j != byArray.length; ++j) {
                int n3 = n2 + j;
                byArray4[n3] = (byte)(byArray4[n3] ^ byArray[j]);
            }
        }
    }

    private static byte[] pbkdf2GenerateDerivedKey(String string, byte[] byArray, byte[] byArray2, int n, int n2) throws NoSuchAlgorithmException, InvalidKeyException, ShortBufferException {
        Mac mac = Mac.getInstance(string);
        mac.init(new SecretKeySpec(byArray, string));
        byte[] byArray3 = new byte[mac.getMacLength()];
        int n3 = mac.getMacLength();
        int n4 = (n2 + n3 - 1) / n3;
        byte[] byArray4 = new byte[4];
        byte[] byArray5 = new byte[n4 * n3];
        int n5 = 0;
        for (int i = 1; i <= n4; ++i) {
            int n6;
            int n7 = 3;
            do {
                n6 = n7--;
            } while ((byArray4[n6] = (byte)(byArray4[n6] + 1)) == 0);
            CommonUtils.pbkdf2F(mac, byArray3, byArray2, n, byArray4, byArray5, n5);
            n5 += n3;
        }
        return byArray5;
    }

    public static boolean KeyDerivation(String string, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n, ByteBuffer byteBuffer3) {
        if (byteBuffer2 == null || !byteBuffer2.hasRemaining()) {
            return false;
        }
        if (byteBuffer3 == null || !byteBuffer3.hasRemaining()) {
            return false;
        }
        try {
            byte[] byArray = new byte[byteBuffer2.remaining()];
            byteBuffer2.get(byArray);
            byte[] byArray2 = null;
            if (byteBuffer != null && byteBuffer.hasRemaining()) {
                byArray2 = new byte[byteBuffer.remaining()];
                byteBuffer.get(byArray2);
            }
            byte[] byArray3 = CommonUtils.pbkdf2GenerateDerivedKey(string, byArray2, byArray, n, byteBuffer3.remaining());
            int n2 = Math.min(byArray3.length, byteBuffer3.remaining());
            byteBuffer3.put(byArray3, 0, n2);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean checkCryptoSupport() {
        if (mSystemCryptoSupport == null) {
            try {
                AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("EC");
                algorithmParameters.init(new ECGenParameterSpec("secp256r1"));
                ECParameterSpec eCParameterSpec = algorithmParameters.getParameterSpec(ECParameterSpec.class);
                KeyFactory keyFactory = KeyFactory.getInstance("EC");
                mSystemCryptoSupport = Boolean.TRUE;
            }
            catch (Exception exception) {
                mSystemCryptoSupport = Boolean.FALSE;
            }
        }
        return mSystemCryptoSupport;
    }
}

