/*
 * Decompiled with CFR 0.152.
 */
package io.agora.utils.crypto;

import android.util.Base64;
import io.agora.utils.crypto.AsymmetricKeyPair;
import io.agora.utils.crypto.CryptoCertification;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;

public class CryptoCertStore {
    private static KeyStore root_ca_store_;

    private CryptoCertification ImportFromStream(BufferedInputStream bufferedInputStream) throws CertificateException, IOException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        if (certificateFactory == null) {
            return null;
        }
        ArrayList<CryptoCertification> arrayList = new ArrayList<CryptoCertification>();
        while (bufferedInputStream.available() > 0) {
            Certificate certificate = certificateFactory.generateCertificate(bufferedInputStream);
            if (!(certificate instanceof X509Certificate)) continue;
            arrayList.add(new CryptoCertification((X509Certificate)certificate));
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return (CryptoCertification)arrayList.get(0);
    }

    public CryptoCertification ImportCertFromFile(String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            return this.ImportFromStream(bufferedInputStream);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public CryptoCertification ImportCertFromPemString(String string) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            BufferedInputStream bufferedInputStream = new BufferedInputStream(byteArrayInputStream);
            return this.ImportFromStream(bufferedInputStream);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public CryptoCertification ImportCertFromData(ByteBuffer byteBuffer) {
        try {
            byte[] byArray = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("-----BEGIN CERTIFICATE-----\n");
            stringBuilder.append(new String(Base64.encode((byte[])byArray, (int)0)));
            stringBuilder.append("-----END CERTIFICATE-----");
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(stringBuilder.toString().getBytes()));
            return this.ImportFromStream(bufferedInputStream);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public CryptoCertification GetCertByName(String string) {
        try {
            KeyStore keyStore = CryptoCertStore.AndroidCAStore();
            if (keyStore == null) {
                return null;
            }
            Certificate certificate = keyStore.getCertificate(string);
            if (certificate == null) {
                return null;
            }
            if (!(certificate instanceof X509Certificate)) {
                return null;
            }
            return new CryptoCertification((X509Certificate)certificate);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public AsymmetricKeyPair GetKeyPairByName(String string, String string2) {
        try {
            KeyStore keyStore = KeyStore.getInstance("AndroidKeyStore");
            keyStore.load(null);
            KeyStore.Entry entry = keyStore.getEntry(string, null);
            if (entry == null) {
                return null;
            }
            if (!(entry instanceof KeyStore.PrivateKeyEntry)) {
                return null;
            }
            PrivateKey privateKey = ((KeyStore.PrivateKeyEntry)entry).getPrivateKey();
            PublicKey publicKey = ((KeyStore.PrivateKeyEntry)entry).getCertificate().getPublicKey();
            AsymmetricKeyPair asymmetricKeyPair = new AsymmetricKeyPair();
            asymmetricKeyPair.SetKeyPair(privateKey, publicKey);
            return asymmetricKeyPair;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object[] GetAllTrustedCerts() {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            KeyStore keyStore = CryptoCertStore.AndroidCAStore();
            if (keyStore == null) {
                return null;
            }
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                Certificate certificate;
                String string = enumeration.nextElement();
                if (!keyStore.isCertificateEntry(string) || !((certificate = keyStore.getCertificate(string)) instanceof X509Certificate)) continue;
                arrayList.add(string);
            }
            return arrayList.toArray();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object[] GetAllKeys() {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            KeyStore keyStore = KeyStore.getInstance("AndroidKeyStore");
            if (keyStore == null) {
                return null;
            }
            keyStore.load(null);
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                if (!keyStore.isKeyEntry(string)) continue;
                arrayList.add(string);
            }
            return arrayList.toArray();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static KeyStore AndroidCAStore() {
        if (root_ca_store_ != null) {
            return root_ca_store_;
        }
        try {
            root_ca_store_ = KeyStore.getInstance("AndroidCAStore");
            root_ca_store_.load(null);
        }
        catch (Exception exception) {
            root_ca_store_ = null;
        }
        return root_ca_store_;
    }
}

