/*
 * Decompiled with CFR 0.152.
 */
package io.agora.utils.crypto;

import java.nio.ByteBuffer;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import org.apache.http.conn.ssl.BrowserCompatHostnameVerifier;

public class CryptoCertification {
    private X509Certificate cert_ = null;

    public CryptoCertification(X509Certificate x509Certificate) {
        this.cert_ = x509Certificate;
    }

    public String GetIssuerName() {
        return this.cert_.getIssuerX500Principal().getName();
    }

    public boolean VerifySignature(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        if (!byteBuffer.hasRemaining() || !byteBuffer2.hasRemaining()) {
            return false;
        }
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byArray);
        byte[] byArray2 = new byte[byteBuffer2.remaining()];
        byteBuffer2.get(byArray2);
        Signature[] signatureArray = new Signature[2];
        for (int i = 0; i < signatureArray.length; ++i) {
            signatureArray[i] = null;
        }
        try {
            signatureArray[0] = Signature.getInstance("SHA256withRSA");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            signatureArray[1] = Signature.getInstance("SHA256withRSA/PSS");
        }
        catch (Exception exception) {
            // empty catch block
        }
        PublicKey publicKey = this.cert_.getPublicKey();
        if (publicKey == null) {
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < signatureArray.length; ++i) {
            Signature signature = signatureArray[i];
            if (signature == null) continue;
            try {
                signature.initVerify(this.cert_);
                signature.update(byArray);
                boolean bl2 = signature.verify(byArray2);
                if (!bl2) continue;
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean VerifyHost(String string) {
        BrowserCompatHostnameVerifier browserCompatHostnameVerifier = new BrowserCompatHostnameVerifier();
        try {
            browserCompatHostnameVerifier.verify(string, this.cert_);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public ByteBuffer Export() {
        try {
            byte[] byArray = this.cert_.getEncoded();
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length);
            byteBuffer.put(byArray);
            return byteBuffer;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public X509Certificate Get() {
        return this.cert_;
    }
}

