/*
 * Decompiled with CFR 0.152.
 */
package io.agora.utils.crypto;

import io.agora.utils.crypto.CryptoTrustManager;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;

public class CryptoSslEngine {
    private SSLContext context_;
    private long nativeHandle_ = 0L;
    private SSLEngine engine_;
    private ByteBuffer EMPTY;
    private String verify_host_;
    private List<String> ciphers_ = new ArrayList<String>();
    private boolean is_client_;
    private boolean broken_ = false;
    private Map<String, String> user_cas_ = new HashMap<String, String>();
    private boolean handshake_done_ = false;

    public CryptoSslEngine(boolean bl) {
        this.EMPTY = ByteBuffer.allocate(0);
        this.is_client_ = bl;
    }

    public void SetVerifyHost(String string) {
        this.verify_host_ = string;
    }

    public void AddUserCA(String string, String string2) {
        this.user_cas_.put(string, string2);
    }

    public void AddCipherSuite(String string) {
        this.ciphers_.add(string);
    }

    public void SetNativeHandle(long l) {
        this.nativeHandle_ = l;
    }

    public boolean Initialize() {
        Object object;
        try {
            this.context_ = SSLContext.getInstance("TLS");
            object = new CryptoTrustManager();
            ((CryptoTrustManager)object).SetHostName(this.verify_host_);
            ((CryptoTrustManager)object).SetUserCAs(this.user_cas_);
            if (!((CryptoTrustManager)object).Initialize()) {
                return false;
            }
            this.context_.init(null, new TrustManager[]{object}, null);
        }
        catch (Exception exception) {
            return false;
        }
        this.engine_ = this.context_.createSSLEngine();
        object = new SSLParameters();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!this.ciphers_.isEmpty()) {
            for (String string : this.ciphers_) {
                if (string.contains("TLS_FALLBACK_SCSV")) continue;
                arrayList.add(string);
            }
        } else {
            for (String string : this.engine_.getSupportedCipherSuites()) {
                if (string.contains("TLS_FALLBACK_SCSV")) continue;
                arrayList.add(string);
            }
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        ((SSLParameters)object).setCipherSuites(stringArray);
        if (!this.is_client_) {
            ((SSLParameters)object).setNeedClientAuth(true);
        }
        ((SSLParameters)object).setProtocols(this.engine_.getSupportedProtocols());
        this.engine_.setSSLParameters((SSLParameters)object);
        this.engine_.setUseClientMode(this.is_client_);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long OnTransportData(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        if (this.broken_) {
            return -1L;
        }
        ByteBuffer byteBuffer3 = byteBuffer == null ? this.EMPTY : byteBuffer;
        try {
            block8: while (true) {
                SSLEngineResult.HandshakeStatus handshakeStatus = this.engine_.getHandshakeStatus();
                switch (handshakeStatus) {
                    case FINISHED: 
                    case NOT_HANDSHAKING: {
                        if (this.handshake_done_) {
                            this.ChangeHandshakeStatus(true);
                            long l = byteBuffer.remaining();
                            boolean bl = byteBuffer2 != null && byteBuffer2.hasRemaining();
                            SSLEngineResult sSLEngineResult = this.engine_.unwrap(byteBuffer3, byteBuffer2);
                            long l2 = 0L;
                            if (!bl) return l2;
                            return byteBuffer2.position();
                        }
                        this.engine_.beginHandshake();
                        break;
                    }
                    case NEED_TASK: {
                        this.engine_.getDelegatedTask().run();
                        break;
                    }
                    case NEED_WRAP: {
                        int n = this.engine_.getSession().getPacketBufferSize();
                        Object object = ByteBuffer.allocateDirect(n);
                        SSLEngineResult sSLEngineResult = this.engine_.wrap(this.EMPTY, (ByteBuffer)object);
                        if (sSLEngineResult.getStatus().equals((Object)SSLEngineResult.Status.CLOSED)) {
                            this.ChangeHandshakeStatus(false);
                            return -1L;
                        }
                        if (sSLEngineResult.getStatus().equals((Object)SSLEngineResult.Status.BUFFER_OVERFLOW)) {
                            this.ChangeHandshakeStatus(false);
                            return -1L;
                        }
                        ((ByteBuffer)object).flip();
                        if (((Buffer)object).limit() != 0) {
                            CryptoSslEngine.nativeTransportWrite(this.nativeHandle_, (ByteBuffer)object, ((Buffer)object).limit());
                        }
                        if (!sSLEngineResult.getHandshakeStatus().equals((Object)SSLEngineResult.HandshakeStatus.FINISHED)) continue block8;
                        this.ChangeHandshakeStatus(true);
                        return 0L;
                    }
                    case NEED_UNWRAP: {
                        if (!byteBuffer3.hasRemaining()) {
                            return 0L;
                        }
                        int n = byteBuffer3.remaining();
                        Object object = this.engine_.unwrap(byteBuffer3, this.EMPTY);
                        int n2 = byteBuffer3.remaining();
                        if (((SSLEngineResult)object).getStatus().equals((Object)SSLEngineResult.Status.CLOSED)) {
                            this.ChangeHandshakeStatus(false);
                            return -1L;
                        }
                        if (((SSLEngineResult)object).getStatus().equals((Object)SSLEngineResult.Status.BUFFER_UNDERFLOW)) {
                            this.ChangeHandshakeStatus(false);
                            return -1L;
                        }
                        if (!((SSLEngineResult)object).getHandshakeStatus().equals((Object)SSLEngineResult.HandshakeStatus.FINISHED)) continue block8;
                        this.ChangeHandshakeStatus(true);
                        return 0L;
                    }
                }
            }
        }
        catch (Exception exception) {
            if (this.handshake_done_) return -1L;
            this.ChangeHandshakeStatus(false);
            return -1L;
        }
    }

    public long EncryptData(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        if (!this.handshake_done_) {
            return -1L;
        }
        try {
            this.engine_.wrap(byteBuffer, byteBuffer2);
        }
        catch (Exception exception) {
            return -1L;
        }
        long l = byteBuffer.position();
        if (l != 0L) {
            byteBuffer2.flip();
            CryptoSslEngine.nativeTransportWrite(this.nativeHandle_, byteBuffer2, byteBuffer2.limit());
        }
        return l;
    }

    public long BeginHandshake() {
        if (this.engine_.getHandshakeStatus().equals((Object)SSLEngineResult.HandshakeStatus.FINISHED)) {
            return 1L;
        }
        try {
            this.broken_ = false;
            this.engine_.beginHandshake();
            this.OnTransportData(this.EMPTY, this.EMPTY);
        }
        catch (Exception exception) {
            this.ChangeHandshakeStatus(false);
            return 0L;
        }
        return 1L;
    }

    private void ChangeHandshakeStatus(boolean bl) {
        if (!bl) {
            this.broken_ = true;
            CryptoSslEngine.nativeNotifyHandshakeStatus(this.nativeHandle_, false);
        } else {
            boolean bl2 = !this.handshake_done_;
            this.broken_ = false;
            this.handshake_done_ = true;
            if (bl2) {
                CryptoSslEngine.nativeNotifyHandshakeStatus(this.nativeHandle_, true);
            }
        }
    }

    private static native long nativeTransportWrite(long var0, ByteBuffer var2, long var3);

    private static native void nativeNotifyHandshakeStatus(long var0, boolean var2);
}

