/*
 * Decompiled with CFR 0.152.
 */
package io.agora.utils.crypto;

import io.agora.utils.crypto.CryptoCertStore;
import io.agora.utils.crypto.CryptoCertification;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.http.conn.ssl.BrowserCompatHostnameVerifier;
import org.apache.http.conn.ssl.X509HostnameVerifier;

public class CryptoTrustManager
implements X509TrustManager {
    private List<X509Certificate> certs_ = new ArrayList<X509Certificate>();
    private List<X509Certificate> user_root_certs_;
    private X509TrustManager system_x509_tm_;
    private String host_name_;
    private X509HostnameVerifier host_verifier_;
    private Map<String, String> user_cas_;

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        X509TrustManager x509TrustManager;
        if (x509CertificateArray.length == 0) {
            return;
        }
        if (this.host_verifier_ != null) {
            try {
                this.host_verifier_.verify(this.host_name_, x509CertificateArray[0]);
            }
            catch (Exception exception) {
                throw new CertificateException();
            }
        }
        if ((x509TrustManager = this.system_x509_tm_) == null) {
            throw new CertificateException();
        }
        x509TrustManager.checkServerTrusted(x509CertificateArray, "RSA");
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        assert (false);
        throw new CertificateException();
    }

    public void AddUserRootCerts(String[] stringArray) {
        CryptoCertStore cryptoCertStore = new CryptoCertStore();
        for (String string : stringArray) {
            CryptoCertification cryptoCertification = cryptoCertStore.ImportCertFromPemString(string);
            if (cryptoCertification == null) continue;
            this.user_root_certs_.add(cryptoCertification.Get());
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }

    public void SetHostName(String string) {
        this.host_name_ = string;
    }

    public void SetUserCAs(Map<String, String> map) {
        this.user_cas_ = map;
    }

    public boolean Initialize() {
        try {
            Object object;
            Object object2;
            if (this.host_name_ != null) {
                this.host_verifier_ = new BrowserCompatHostnameVerifier();
            }
            KeyStore keyStore = null;
            if (this.user_cas_ != null && !this.user_cas_.isEmpty()) {
                keyStore = KeyStore.getInstance("AndroidKeyStore");
                keyStore.load(null);
                object2 = new CryptoCertStore();
                object = this.user_cas_.entrySet().iterator();
                while (object.hasNext()) {
                    Map.Entry entry = (Map.Entry)object.next();
                    CryptoCertification cryptoCertification = ((CryptoCertStore)object2).ImportCertFromPemString((String)entry.getValue());
                    if (cryptoCertification == null) continue;
                    keyStore.setCertificateEntry((String)entry.getKey(), cryptoCertification.Get());
                }
            }
            object2 = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            ((TrustManagerFactory)object2).init(keyStore);
            for (TrustManager trustManager : object = ((TrustManagerFactory)object2).getTrustManagers()) {
                if (!(trustManager instanceof X509TrustManager)) continue;
                this.system_x509_tm_ = (X509TrustManager)trustManager;
                break;
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void AppendPemCert(String string) {
        CryptoCertStore cryptoCertStore = new CryptoCertStore();
        CryptoCertification cryptoCertification = cryptoCertStore.ImportCertFromPemString(string);
        if (cryptoCertification == null) {
            return;
        }
        this.certs_.add(cryptoCertification.Get());
    }

    public boolean Evaluate() {
        try {
            X509Certificate[] x509CertificateArray = new X509Certificate[this.certs_.size()];
            this.certs_.toArray(x509CertificateArray);
            if (this.system_x509_tm_ == null) {
                return false;
            }
            this.system_x509_tm_.checkServerTrusted(x509CertificateArray, "RSA");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

