/*
 * Decompiled with CFR 0.152.
 */
package io.agora.utils.crypto;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class Hash {
    private MessageDigest commonAlg = null;
    private Mac hmacAlg = null;

    public Hash(String string, boolean bl, byte[] byArray) {
        try {
            if (bl) {
                this.hmacAlg = Mac.getInstance(string);
                if (this.hmacAlg == null) {
                    return;
                }
                this.hmacAlg.init(new SecretKeySpec(byArray, string));
            } else {
                this.commonAlg = MessageDigest.getInstance(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void Update(ByteBuffer byteBuffer) {
        if (this.hmacAlg != null) {
            this.hmacAlg.update(byteBuffer);
        } else if (this.commonAlg != null) {
            this.commonAlg.update(byteBuffer);
        }
    }

    public void Final(ByteBuffer byteBuffer) {
        if (this.hmacAlg != null) {
            byte[] byArray = this.hmacAlg.doFinal();
            byteBuffer.put(byArray);
        } else if (this.commonAlg != null) {
            byte[] byArray = this.commonAlg.digest();
            byteBuffer.put(byArray);
        }
    }

    public void Reset() {
        if (this.hmacAlg != null) {
            this.hmacAlg.reset();
        } else if (this.commonAlg != null) {
            this.commonAlg.reset();
        }
    }
}

