/*
 * Decompiled with CFR 0.152.
 */
package io.agora.utils.crypto;

import android.os.Build;
import android.text.TextUtils;
import java.nio.ByteBuffer;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class Symmetric {
    private SecretKeySpec key;
    private String cipher;
    private Boolean isIvRequired;
    private Boolean isGcm;
    private boolean padding;
    private long blockSize;
    static final int defaultGcmAuthTagLen = 16;

    public boolean SetKey(ByteBuffer byteBuffer) {
        if (TextUtils.isEmpty((CharSequence)this.cipher)) {
            return false;
        }
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byArray);
        try {
            this.key = new SecretKeySpec(byArray, this.cipher);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public boolean SetCipher(String string, long l, boolean bl) {
        this.cipher = string;
        this.isIvRequired = !string.contains("ECB");
        this.isGcm = string.contains("GCM");
        this.blockSize = l;
        this.padding = bl;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int doCommonJob(String string, ByteBuffer byteBuffer, byte[] byArray, ByteBuffer byteBuffer2, ByteBuffer byteBuffer3, int n, int n2) {
        int n3 = 0;
        try {
            Cipher cipher = Cipher.getInstance(string);
            if (cipher == null) {
                return 0;
            }
            if (this.isIvRequired.booleanValue()) {
                if (byArray == null) return 0;
                boolean bl = false;
                if (this.isGcm.booleanValue()) {
                    if (Build.VERSION.SDK_INT >= 19) {
                        Object var11_13 = null;
                        GCMParameterSpec gCMParameterSpec = new GCMParameterSpec(n * 8, byArray);
                        cipher.init(n2, (Key)this.key, gCMParameterSpec);
                        bl = true;
                    } else if (n != 16) {
                        return 0;
                    }
                }
                if (!bl) {
                    Object var11_15 = null;
                    IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray);
                    cipher.init(n2, (Key)this.key, ivParameterSpec);
                    bl = true;
                }
            } else {
                cipher.init(n2, this.key);
            }
            if (Build.VERSION.SDK_INT < 19) return cipher.doFinal(byteBuffer, byteBuffer3);
            if (byteBuffer2 == null) return cipher.doFinal(byteBuffer, byteBuffer3);
            if (byteBuffer2.remaining() == 0) return cipher.doFinal(byteBuffer, byteBuffer3);
            byte[] byArray2 = new byte[byteBuffer2.remaining()];
            byteBuffer2.get(byArray2);
            cipher.updateAAD(byArray2, 0, byArray2.length);
            return cipher.doFinal(byteBuffer, byteBuffer3);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int Encrypt(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, ByteBuffer byteBuffer3, ByteBuffer byteBuffer4, int n) {
        int n2;
        int n3 = n2 = this.isGcm != false ? byteBuffer.remaining() + n : byteBuffer.remaining();
        if (this.isGcm.booleanValue() && byteBuffer4.capacity() < byteBuffer.remaining() + n) {
            return 0;
        }
        if (byteBuffer4.capacity() < byteBuffer.remaining()) {
            return 0;
        }
        String string = this.cipher;
        string = this.padding ? string + "PKCS5Padding" : string + "NoPadding";
        byte[] byArray = null;
        if (byteBuffer2 != null && byteBuffer2.hasRemaining()) {
            byArray = new byte[byteBuffer2.remaining()];
            byteBuffer2.get(byArray);
        }
        return this.doCommonJob(string, byteBuffer, byArray, byteBuffer3, byteBuffer4, n, 1);
    }

    public int Decrypt(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, ByteBuffer byteBuffer3, ByteBuffer byteBuffer4, int n) {
        String string;
        int n2;
        if (this.isGcm.booleanValue() && byteBuffer4.capacity() < byteBuffer.remaining() - n) {
            return 0;
        }
        ByteBuffer byteBuffer5 = ByteBuffer.allocate(byteBuffer4.remaining() + 256);
        byte[] byArray = null;
        if (byteBuffer2 != null && byteBuffer2.hasRemaining()) {
            byArray = new byte[byteBuffer2.remaining()];
            byteBuffer2.get(byArray);
        }
        if ((n2 = this.doCommonJob(string = this.cipher + (this.padding ? "PKCS5Padding" : "NoPadding"), byteBuffer, byArray, byteBuffer3, byteBuffer5, n, 2)) != 0) {
            int n3 = byteBuffer4.remaining();
            int n4 = n3 > n2 ? n2 : n3;
            byteBuffer5.rewind();
            byte[] byArray2 = new byte[n4];
            byteBuffer5.get(byArray2, 0, n4);
            byteBuffer4.put(byArray2, 0, n4);
        }
        return n2;
    }
}

