/*
 * Decompiled with CFR 0.152.
 */
package io.agora.utils.processor;

import java.io.File;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

@SupportedAnnotationTypes(value={"io.agora.utils.annotations.CallByNative"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class Processor
extends AbstractProcessor {
    private ProcessingEnvironment processingEnv = null;
    private HashMap<String, StringBuilder> content = new HashMap();
    private FileWriter logger = null;
    private int function_index = 0;
    private static final Map<TypeKind, String> javaPrimitive = new HashMap<TypeKind, String>();
    private static final Map<TypeKind, String> javaPrimitiveToNative;
    private static final Map<TypeKind, String> jniMethodType;

    private void log(String string) {
        if (this.logger == null) {
            return;
        }
        try {
            this.logger.append(string).append("\n");
            this.logger.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void appendLine(StringBuilder stringBuilder, String string) {
        stringBuilder.append(string).append("\n");
    }

    private void flush() {
        for (Map.Entry<String, StringBuilder> entry : this.content.entrySet()) {
            File file = null;
            try {
                String string = entry.getKey().replace(".", "_");
                file = new File("gen/jni/jni/" + string + ".h");
                FileWriter fileWriter = new FileWriter(file, false);
                fileWriter.append(entry.getValue().toString());
                fileWriter.flush();
                fileWriter.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void init(ProcessingEnvironment processingEnvironment) {
        this.processingEnv = processingEnvironment;
        File file = new File("gen/jni/jni");
        if (!file.exists()) {
            file.mkdirs();
        }
        File file2 = new File("gen/jni/log");
        try {
            this.logger = new FileWriter(file2, false);
        }
        catch (Exception exception) {
            this.logger = null;
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        if (set.size() == 0) {
            return true;
        }
        for (TypeElement object : set) {
            Set<? extends Element> set2 = roundEnvironment.getElementsAnnotatedWith(object);
            for (Element element : set2) {
                String string = element.getEnclosingElement().asType().toString();
                if (!this.content.containsKey(string)) {
                    StringBuilder stringBuilder = new StringBuilder();
                    this.generateFileHeader(stringBuilder, string);
                    this.content.put(string, stringBuilder);
                    TypeElement typeElement = (TypeElement)element.getEnclosingElement();
                    for (Element element2 : typeElement.getEnclosedElements()) {
                        if (element2.getKind() != ElementKind.CONSTRUCTOR) continue;
                        this.generateJniFunctionStub(this.content.get(string), object, element.getEnclosingElement(), element2);
                    }
                }
                this.generateJniFunctionStub(this.content.get(string), object, element.getEnclosingElement(), element);
            }
        }
        for (Map.Entry entry : this.content.entrySet()) {
            this.generateFileFooter((StringBuilder)entry.getValue(), (String)entry.getKey());
        }
        this.flush();
        return true;
    }

    private void generateFileHeader(StringBuilder stringBuilder, String string) {
        this.appendLine(stringBuilder, "//");
        this.appendLine(stringBuilder, "// Agora Real Time Engagement");
        this.appendLine(stringBuilder, "// Created by auto jni tool, Please do NOT modify this file");
        this.appendLine(stringBuilder, "//");
        this.appendLine(stringBuilder, "");
        this.appendLine(stringBuilder, "#pragma once");
        this.appendLine(stringBuilder, "#include <jni.h>");
        this.appendLine(stringBuilder, "#include <memory>");
        this.appendLine(stringBuilder, "#include \"jni/ref.h\"");
        this.appendLine(stringBuilder, "#include \"jni/class.h\"");
        this.appendLine(stringBuilder, "#include \"jni/env.h\"");
        this.appendLine(stringBuilder, "#include \"jni/exception.h\"");
        this.appendLine(stringBuilder, "");
        String[] stringArray = string.split("[.]");
        this.appendLine(stringBuilder, "namespace {");
        this.appendLine(stringBuilder, "using namespace agora::utils::jni;");
        this.appendLine(stringBuilder, "");
        this.appendLine(stringBuilder, "class Java" + stringArray[stringArray.length - 1] + " {");
        this.appendLine(stringBuilder, " private:");
        this.appendLine(stringBuilder, "  Java" + stringArray[stringArray.length - 1] + "(const JavaLocalRef& obj): instance_(obj) {}");
        this.appendLine(stringBuilder, "");
        this.appendLine(stringBuilder, " public:");
        this.appendLine(stringBuilder, "  static std::unique_ptr<Java" + stringArray[stringArray.length - 1] + "> Create(const JavaLocalRef& obj) {");
        this.appendLine(stringBuilder, "    auto ret = std::unique_ptr<Java" + stringArray[stringArray.length - 1] + ">(new (std::nothrow) Java" + stringArray[stringArray.length - 1] + "(obj));");
        this.appendLine(stringBuilder, "    if (!ret) { return nullptr; }");
        this.appendLine(stringBuilder, "    if (!ret->InstanceValid()) { return nullptr; }");
        this.appendLine(stringBuilder, "    if (!ret->ClassValid()) { return nullptr; }");
        this.appendLine(stringBuilder, "    return ret;");
        this.appendLine(stringBuilder, "  }");
        this.appendLine(stringBuilder, "");
    }

    private void generateFileFooter(StringBuilder stringBuilder, String string) {
        String[] stringArray = string.split("[.]");
        this.appendLine(stringBuilder, "");
        this.appendLine(stringBuilder, " public: // Helper functions");
        this.appendLine(stringBuilder, "  bool InstanceValid() {");
        this.appendLine(stringBuilder, "    return !instance_.NullOrEmpty();");
        this.appendLine(stringBuilder, "  }");
        this.appendLine(stringBuilder, "");
        this.appendLine(stringBuilder, "  static bool ClassValid() {");
        this.appendLine(stringBuilder, "    return !GetClass().NullOrEmpty();");
        this.appendLine(stringBuilder, "  }");
        this.appendLine(stringBuilder, "");
        this.appendLine(stringBuilder, "  JavaGlobalRef Obj() const {");
        this.appendLine(stringBuilder, "    return instance_;");
        this.appendLine(stringBuilder, "  }");
        this.appendLine(stringBuilder, "");
        this.appendLine(stringBuilder, " private:");
        this.appendLine(stringBuilder, "  JavaGlobalRef instance_;");
        this.appendLine(stringBuilder, "  static JavaGlobalRef& GetClass() {");
        this.appendLine(stringBuilder, "    static JavaGlobalRef class_ = JavaLocalRef::Null();");
        this.appendLine(stringBuilder, "    static bool initialized = false;");
        this.appendLine(stringBuilder, "    if (!initialized) {");
        this.appendLine(stringBuilder, "      initialized = true;");
        this.appendLine(stringBuilder, "      class_ = GetJavaClass(\"" + string.replace(".", "/") + "\");");
        this.appendLine(stringBuilder, "    }");
        this.appendLine(stringBuilder, "    return class_;");
        this.appendLine(stringBuilder, "  }");
        this.appendLine(stringBuilder, "};");
        this.appendLine(stringBuilder, "}  // namespace ");
        this.appendLine(stringBuilder, "");
    }

    private void generateJniFunctionStub(StringBuilder stringBuilder, TypeElement typeElement, Element element, Element element2) {
        ++this.function_index;
        if (!element2.getModifiers().contains((Object)Modifier.PUBLIC)) {
            return;
        }
        String[] stringArray = element.asType().toString().split("[.]");
        String string = stringArray[stringArray.length - 1];
        if (element2.getKind() == ElementKind.CONSTRUCTOR) {
            this.appendLine(stringBuilder, " public:");
            this.appendLine(stringBuilder, "  static std::unique_ptr<Java" + string + "> Create(" + this.generateNativeParametersSignature(element2) + ") {");
            this.appendLine(stringBuilder, "    auto ret = std::unique_ptr<Java" + string + ">(new (std::nothrow) Java" + string + "(" + this.generateNativeMethodParameterDefinition(element2, false) + "));");
            this.appendLine(stringBuilder, "    if (!ret) { return nullptr; }");
            this.appendLine(stringBuilder, "    if (!ret->InstanceValid()) { return nullptr; }");
            this.appendLine(stringBuilder, "    if (!ret->ClassValid()) { return nullptr; }");
            this.appendLine(stringBuilder, "    return ret;");
            this.appendLine(stringBuilder, "  }");
            this.appendLine(stringBuilder, "");
            this.appendLine(stringBuilder, " private:");
            this.appendLine(stringBuilder, "  " + this.generateNativeMethodSignature("Java" + string, element2, false) + " : instance_(JavaLocalRef::Null()) {");
        } else if (element2.getModifiers().contains((Object)Modifier.STATIC)) {
            this.appendLine(stringBuilder, " public:");
            this.appendLine(stringBuilder, "  static " + this.generateNativeMethodSignature(element2.getSimpleName().toString(), element2, true) + " {");
        } else {
            this.appendLine(stringBuilder, " public:");
            this.appendLine(stringBuilder, "  " + this.generateNativeMethodSignature(element2.getSimpleName().toString(), element2, true) + " {");
        }
        this.appendLine(stringBuilder, "    JNIEnv* env = rte_jni_attach_current_thread();");
        this.appendLine(stringBuilder, "    ExceptionGuard ____guard(env);");
        this.appendLine(stringBuilder, "    static const char kMethodSignature[] = \"" + this.generateMethodSignature(element2, element2.getKind() == ElementKind.CONSTRUCTOR) + "\";");
        this.appendLine(stringBuilder, "    static const char kMethodName[] = \"" + (element2.getKind() == ElementKind.CONSTRUCTOR ? "<init>" : element2.getSimpleName()) + "\";");
        this.appendLine(stringBuilder, "    static jmethodID method_id = nullptr;");
        if (element2.getKind() == ElementKind.CONSTRUCTOR) {
            this.appendLine(stringBuilder, this.generateJMethodPrepare(false));
            this.appendLine(stringBuilder, "    instance_ = JavaLocalRef(env->NewObject((jclass)GetClass().Get(), method_id" + this.generateNativeMethodParameterDefinition(element2, true) + "));");
        } else if (element2.getModifiers().contains((Object)Modifier.STATIC)) {
            this.appendLine(stringBuilder, this.generateJMethodPrepare(true));
            this.appendLine(stringBuilder, "    return " + Processor.generateNativeReturnTypeForCallMethod(element2) + "env->" + Processor.generateNativeCallMethod(element2) + "((jclass)GetClass().Get(), method_id" + this.generateNativeMethodParameterDefinition(element2, true) + ");");
        } else {
            this.appendLine(stringBuilder, this.generateJMethodPrepare(false));
            this.appendLine(stringBuilder, "    return " + Processor.generateNativeReturnTypeForCallMethod(element2) + "env->" + Processor.generateNativeCallMethod(element2) + "(instance_.Get(), method_id" + this.generateNativeMethodParameterDefinition(element2, true) + ");");
        }
        this.appendLine(stringBuilder, "  }");
        this.appendLine(stringBuilder, "");
    }

    private String generateJMethodPrepare(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("    if (method_id == nullptr) {\n");
        stringBuilder.append("      method_id = env->" + (bl ? "GetStaticMethodID" : "GetMethodID") + "((jclass)GetClass().Get(), kMethodName, kMethodSignature);\n");
        stringBuilder.append("    }\n");
        return stringBuilder.toString();
    }

    private String generateNativeMethodSignature(String string, Element element, boolean bl) {
        ExecutableElement executableElement = (ExecutableElement)element;
        return (bl ? this.generateNativeTypeSignature(executableElement.getReturnType(), true) : "") + " " + string + "(" + this.generateNativeParametersSignature(element) + ")";
    }

    private String generateMethodSignature(Element element, boolean bl) {
        ExecutableElement executableElement = (ExecutableElement)element;
        StringBuilder stringBuilder = new StringBuilder("(");
        for (VariableElement variableElement : executableElement.getParameters()) {
            stringBuilder.append(this.generateParameterSignature(variableElement.asType()));
        }
        stringBuilder.append(')');
        if (!bl) {
            stringBuilder.append(this.generateParameterSignature(executableElement.getReturnType()));
        } else {
            stringBuilder.append("V");
        }
        return stringBuilder.toString();
    }

    private String generateParameterSignature(TypeMirror typeMirror) {
        if (typeMirror.getKind() == TypeKind.ARRAY) {
            ArrayType arrayType = (ArrayType)typeMirror;
            return "[" + this.generateParameterSignature(arrayType.getComponentType());
        }
        if (javaPrimitive.containsKey((Object)typeMirror.getKind())) {
            return javaPrimitive.get((Object)typeMirror.getKind());
        }
        if (typeMirror.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)typeMirror;
            return "L" + declaredType.asElement().toString().replace(".", "/") + ";";
        }
        return "L" + typeMirror.toString().replace(".", "/") + ";";
    }

    private String generateNativeTypeSignature(TypeMirror typeMirror, boolean bl) {
        TypeKind typeKind = typeMirror.getKind();
        if (javaPrimitiveToNative.containsKey((Object)typeKind)) {
            return javaPrimitiveToNative.get((Object)typeKind);
        }
        if (typeMirror.toString().equals("java.lang.String")) {
            if (bl) {
                return "JavaLocalRef /* jstring */";
            }
            return "jstring";
        }
        if (bl) {
            return "JavaLocalRef /* " + typeMirror.toString() + " */";
        }
        return "jobject /* " + typeMirror.toString() + " */";
    }

    private static final String generateNativeCallMethod(Element element) {
        ExecutableElement executableElement = (ExecutableElement)element;
        TypeMirror typeMirror = executableElement.getReturnType();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Call");
        if (element.getModifiers().contains((Object)Modifier.STATIC)) {
            stringBuilder.append("Static");
        }
        if (jniMethodType.containsKey((Object)typeMirror.getKind())) {
            stringBuilder.append(jniMethodType.get((Object)typeMirror.getKind()));
        } else {
            stringBuilder.append("Object");
        }
        stringBuilder.append("Method");
        return stringBuilder.toString();
    }

    private static final String generateNativeReturnTypeForCallMethod(Element element) {
        ExecutableElement executableElement = (ExecutableElement)element;
        TypeMirror typeMirror = executableElement.getReturnType();
        StringBuilder stringBuilder = new StringBuilder();
        if (typeMirror.getKind() == TypeKind.VOID) {
            stringBuilder.append("");
        } else if (javaPrimitiveToNative.containsKey((Object)typeMirror.getKind())) {
            stringBuilder.append("(");
            stringBuilder.append(javaPrimitiveToNative.get((Object)typeMirror.getKind()));
            stringBuilder.append(")");
        } else if (typeMirror.toString().equals("java.lang.String")) {
            stringBuilder.append("(jstring)");
        } else {
            stringBuilder.append("(jobject)");
        }
        return stringBuilder.toString();
    }

    private String generateNativeParametersSignature(Element element) {
        ExecutableElement executableElement = (ExecutableElement)element;
        StringBuilder stringBuilder = new StringBuilder();
        List<? extends VariableElement> list = executableElement.getParameters();
        for (int i = 0; i < list.size(); ++i) {
            stringBuilder.append(this.generateNativeTypeSignature(list.get(i).asType(), false));
            stringBuilder.append(" ");
            stringBuilder.append(list.get(i).toString());
            if (i == list.size() - 1) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    private String generateNativeMethodParameterDefinition(Element element, boolean bl) {
        ExecutableElement executableElement = (ExecutableElement)element;
        StringBuilder stringBuilder = new StringBuilder();
        List<? extends VariableElement> list = executableElement.getParameters();
        for (int i = 0; i < list.size(); ++i) {
            if (i != 0 || bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(list.get(i).toString());
        }
        return stringBuilder.toString();
    }

    static {
        javaPrimitive.put(TypeKind.BOOLEAN, "Z");
        javaPrimitive.put(TypeKind.BYTE, "B");
        javaPrimitive.put(TypeKind.CHAR, "C");
        javaPrimitive.put(TypeKind.DOUBLE, "D");
        javaPrimitive.put(TypeKind.FLOAT, "F");
        javaPrimitive.put(TypeKind.INT, "I");
        javaPrimitive.put(TypeKind.LONG, "J");
        javaPrimitive.put(TypeKind.SHORT, "S");
        javaPrimitive.put(TypeKind.VOID, "V");
        javaPrimitiveToNative = new HashMap<TypeKind, String>();
        javaPrimitiveToNative.put(TypeKind.BOOLEAN, "jboolean");
        javaPrimitiveToNative.put(TypeKind.VOID, "void");
        javaPrimitiveToNative.put(TypeKind.SHORT, "jshort");
        javaPrimitiveToNative.put(TypeKind.BYTE, "jbyte");
        javaPrimitiveToNative.put(TypeKind.CHAR, "jchar");
        javaPrimitiveToNative.put(TypeKind.INT, "jint");
        javaPrimitiveToNative.put(TypeKind.LONG, "jlong");
        javaPrimitiveToNative.put(TypeKind.FLOAT, "jfloat");
        javaPrimitiveToNative.put(TypeKind.DOUBLE, "jdouble");
        jniMethodType = new HashMap<TypeKind, String>();
        jniMethodType.put(TypeKind.BOOLEAN, "Boolean");
        jniMethodType.put(TypeKind.VOID, "Void");
        jniMethodType.put(TypeKind.SHORT, "Short");
        jniMethodType.put(TypeKind.BYTE, "Byte");
        jniMethodType.put(TypeKind.CHAR, "Char");
        jniMethodType.put(TypeKind.INT, "Int");
        jniMethodType.put(TypeKind.LONG, "Long");
        jniMethodType.put(TypeKind.FLOAT, "Float");
        jniMethodType.put(TypeKind.DOUBLE, "Double");
    }
}

