/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.kingbase.es.func;

import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.func.column.ColumnExpression;
import com.easy.query.core.func.def.AbstractExpressionSQLFunction;
import com.easy.query.core.util.EasyClassUtil;
import java.util.List;

public class KingbaseESCastSQLFunction
extends AbstractExpressionSQLFunction {
    private final List<ColumnExpression> columnExpressions;
    private final Class<?> targetClass;

    public KingbaseESCastSQLFunction(List<ColumnExpression> columnExpressions, Class<?> targetClass) {
        this.columnExpressions = columnExpressions;
        this.targetClass = targetClass;
    }

    public String sqlSegment(TableAvailable defaultTable) {
        String targetClassName;
        switch (targetClassName = EasyClassUtil.getFullName(this.targetClass)) {
            case "boolean": 
            case "java.lang.Boolean": {
                return "(({0})::varchar not in ('0','false','f','no'))";
            }
            case "byte": 
            case "java.lang.Byte": {
                return "({0})::int2";
            }
            case "char": {
                return "substr(({0})::char, 1, 1)";
            }
            case "java.sql.Time": 
            case "java.time.Time": {
                return "({0})::time";
            }
            case "java.sql.Date": 
            case "java.time.LocalDate": {
                return "({0})::date";
            }
            case "java.sql.Timestamp": 
            case "java.util.Date": 
            case "java.time.LocalDateTime": {
                return "({0})::timestamp";
            }
            case "java.math.BigDecimal": {
                return "({0})::numeric";
            }
            case "double": 
            case "java.lang.Double": 
            case "float": 
            case "java.lang.Float": {
                return "({0})::float8";
            }
            case "short": 
            case "java.lang.Short": {
                return "({0})::int2";
            }
            case "int": 
            case "java.lang.Integer": {
                return "({0})::int4";
            }
            case "long": 
            case "java.lang.Long": {
                return "({0})::int8";
            }
            case "java.util.UUID": {
                return "({0})::uuid";
            }
            case "java.lang.String": {
                return "({0})::text";
            }
        }
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u5f53\u524d\u8f6c\u6362\u51fd\u6570:" + targetClassName);
    }

    public int paramMarks() {
        return this.columnExpressions.size();
    }

    protected List<ColumnExpression> getColumnExpressions() {
        return this.columnExpressions;
    }
}

