/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.kingbase.es.func;

import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.parser.core.base.scec.core.SQLNativeChainExpressionContext;
import com.easy.query.core.func.def.AbstractSQLFunction;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class KingbaseESDateTimeFormatSQLFunction
extends AbstractSQLFunction {
    private final TableAvailable table;
    private final String property;
    private final String javaFormat;

    public KingbaseESDateTimeFormatSQLFunction(TableAvailable table, String property, String javaFormat) {
        this.table = table;
        this.property = property;
        this.javaFormat = javaFormat;
    }

    public String sqlSegment(TableAvailable defaultTable) {
        return this.getSQLSegment();
    }

    public int paramMarks() {
        return 1;
    }

    protected void consume0(SQLNativeChainExpressionContext context) {
        if (this.table == null) {
            context.expression(this.property);
        } else {
            context.expression(this.table, this.property);
        }
    }

    public String getSQLSegment() {
        if (this.javaFormat != null) {
            String format;
            switch (format = this.javaFormat) {
                case "yyyy-MM-dd HH:mm:ss": {
                    return "to_char({0},'YYYY-MM-DD HH24:MI:SS')";
                }
                case "yyyy-MM-dd HH:mm": {
                    return "to_char({0},'YYYY-MM-DD HH24:MI')";
                }
                case "yyyy-MM-dd HH": {
                    return "to_char({0},'YYYY-MM-DD HH24')";
                }
                case "yyyy-MM-dd": {
                    return "to_char({0},'YYYY-MM-DD')";
                }
                case "yyyy-MM": {
                    return "to_char({0},'YYYY-MM')";
                }
                case "yyyyMMddHHmmss": {
                    return "to_char({0},'YYYYMMDDHH24MISS')";
                }
                case "yyyyMMddHHmm": {
                    return "to_char({0},'YYYYMMDDHH24MI')";
                }
                case "yyyyMMddHH": {
                    return "to_char({0},'YYYYMMDDHH24')";
                }
                case "yyyyMMdd": {
                    return "to_char({0},'YYYYMMDD')";
                }
                case "yyyyMM": {
                    return "to_char({0},'YYYYMM')";
                }
                case "yyyy": {
                    return "to_char({0},'YYYY')";
                }
                case "HH:mm:ss": {
                    return "to_char({0},'HH24:MI:SS')";
                }
            }
            format = this.replaceFormat(format);
            String[] argsFinds = new String[]{"YYYY", "YY", "%_a1", "%_a2", "%_a3", "%_a4", "%_a5", "SS", "%_a6"};
            String[] argsSpts = format.split("(M|d|H|h|m|s|t)");
            block46: for (int a2 = 0; a2 < argsSpts.length; ++a2) {
                switch (argsSpts[a2]) {
                    case "M": {
                        argsSpts[a2] = "ltrim(to_char({0},'MM'),'0')";
                        continue block46;
                    }
                    case "d": {
                        argsSpts[a2] = "case when substr(to_char({0},'DD'),1,1) = '0' then substr(to_char({0},'DD'),2,1) else to_char({0},'DD') end";
                        continue block46;
                    }
                    case "H": {
                        argsSpts[a2] = "case when substr(to_char({0},'HH24'),1,1) = '0' then substr(to_char({0},'HH24'),2,1) else to_char({0},'HH24') end";
                        continue block46;
                    }
                    case "h": {
                        argsSpts[a2] = "case when substr(to_char({0},'HH12'),1,1) = '0' then substr(to_char({0},'HH12'),2,1) else to_char({0},'HH12') end";
                        continue block46;
                    }
                    case "m": {
                        argsSpts[a2] = "case when substr(to_char({0},'MI'),1,1) = '0' then substr(to_char({0},'MI'),2,1) else to_char({0},'MI') end";
                        continue block46;
                    }
                    case "s": {
                        argsSpts[a2] = "case when substr(to_char({0},'SS'),1,1) = '0' then substr(to_char({0},'SS'),2,1) else to_char({0},'SS') end";
                        continue block46;
                    }
                    case "t": {
                        argsSpts[a2] = "rtrim(to_char({0},'AM'),'M')";
                        continue block46;
                    }
                    default: {
                        String argsSptsA = argsSpts[a2];
                        if (argsSptsA.startsWith("'")) {
                            argsSptsA = argsSptsA.substring(1);
                        }
                        if (argsSptsA.endsWith("'")) {
                            argsSptsA = argsSptsA.substring(0, argsSptsA.length() - 1);
                        }
                        argsSpts[a2] = Arrays.stream(argsFinds).anyMatch(argsSptsA::contains) ? "to_char({0},'" + argsSptsA + "')" : "'" + argsSptsA + "'";
                    }
                }
            }
            if (argsSpts.length == 1) {
                format = argsSpts[0];
            } else if (argsSpts.length > 1) {
                format = "(" + String.join((CharSequence)" || ", (CharSequence[])Arrays.stream(argsSpts).filter(a -> !a.equals("''")).toArray(String[]::new)) + ")";
            }
            return format.replace("%_a1", "MM").replace("%_a2", "DD").replace("%_a3", "HH24").replace("%_a4", "HH12").replace("%_a5", "MI").replace("%_a6", "AM");
        }
        return "to_char({0},'YYYY-MM-DD HH24:MI:SS.US')";
    }

    protected String replaceFormat(String format) {
        String pattern = "(yyyy|yy|MM|dd|HH|hh|mm|ss|tt)";
        Pattern r = Pattern.compile(pattern);
        Matcher matcher = r.matcher(format);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String match;
            switch (match = matcher.group(1)) {
                case "yyyy": {
                    matcher.appendReplacement(result, "YYYY");
                    break;
                }
                case "yy": {
                    matcher.appendReplacement(result, "YY");
                    break;
                }
                case "MM": {
                    matcher.appendReplacement(result, "%_a1");
                    break;
                }
                case "dd": {
                    matcher.appendReplacement(result, "%_a2");
                    break;
                }
                case "HH": {
                    matcher.appendReplacement(result, "%_a3");
                    break;
                }
                case "hh": {
                    matcher.appendReplacement(result, "%_a4");
                    break;
                }
                case "mm": {
                    matcher.appendReplacement(result, "%_a5");
                    break;
                }
                case "ss": {
                    matcher.appendReplacement(result, "SS");
                    break;
                }
                case "tt": {
                    matcher.appendReplacement(result, "%_a6");
                }
            }
        }
        matcher.appendTail(result);
        return result.toString();
    }
}

