/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.model;

import com.easypost.exception.EasyPostException;
import com.easypost.model.ApiKey;
import com.easypost.model.ApiKeys;
import com.easypost.net.EasyPostResource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class User
extends EasyPostResource {
    public String id;
    String name;
    String email;
    String phoneNumber;
    String balance;
    String rechargeAmount;
    String secondaryRechargeAmount;
    String rechargeThreshold;
    List<User> children;

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public String getBalance() {
        return this.balance;
    }

    public void setBalance(String balance) {
        this.balance = balance;
    }

    public String getRechargeAmount() {
        return this.rechargeAmount;
    }

    public void setRechargeAmount(String rechargeAmount) {
        this.rechargeAmount = rechargeAmount;
    }

    public String getSecondaryRechargeAmount() {
        return this.secondaryRechargeAmount;
    }

    public void setSecondaryRechargeAmount(String secondaryRechargeAmount) {
        this.secondaryRechargeAmount = secondaryRechargeAmount;
    }

    public String getRechargeThreshold() {
        return this.rechargeThreshold;
    }

    public void setRechargeThreshold(String rechargeThreshold) {
        this.rechargeThreshold = rechargeThreshold;
    }

    public List<User> getChildren() {
        return this.children;
    }

    public void setChildren(List<User> children) {
        this.children = children;
    }

    public static User retrieve(String id) throws EasyPostException {
        return User.retrieve(id, null);
    }

    public static User retrieve(String id, String apiKey) throws EasyPostException {
        return User.request(EasyPostResource.RequestMethod.GET, User.instanceURL(User.class, id), null, User.class, apiKey);
    }

    public static User retrieveMe() throws EasyPostException {
        return User.retrieveMe(null);
    }

    public static User retrieveMe(String apiKey) throws EasyPostException {
        return User.request(EasyPostResource.RequestMethod.GET, User.classURL(User.class), null, User.class, apiKey);
    }

    public static User create() throws EasyPostException {
        return User.create(null, null);
    }

    public static User create(Map<String, Object> params) throws EasyPostException {
        return User.create(params, null);
    }

    public static User create(Map<String, Object> params, String apiKey) throws EasyPostException {
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        wrappedParams.put("user", params);
        return User.request(EasyPostResource.RequestMethod.POST, User.classURL(User.class), wrappedParams, User.class, apiKey, false);
    }

    public User update(Map<String, Object> params) throws EasyPostException {
        return this.update(params, null);
    }

    public User update(Map<String, Object> params, String apiKey) throws EasyPostException {
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        wrappedParams.put("user", params);
        User response = User.request(EasyPostResource.RequestMethod.PUT, User.instanceURL(User.class, this.getId()), wrappedParams, User.class, apiKey);
        this.merge(this, response);
        return this;
    }

    public List<ApiKey> apiKeys() throws EasyPostException {
        ApiKeys parentKeys = ApiKeys.all();
        if (this.getId() == parentKeys.getId()) {
            return parentKeys.getKeys();
        }
        for (int i = 0; i < parentKeys.children.size(); ++i) {
            if (!this.getId().equals(parentKeys.children.get(i).getId())) continue;
            return parentKeys.children.get(i).getKeys();
        }
        throw new EasyPostException("Unable to find api key. Please contact support@easypost.com");
    }
}

