/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.model;

import com.easypost.exception.EasyPostException;
import com.easypost.model.Address;
import com.easypost.model.Container;
import com.easypost.model.CustomsInfo;
import com.easypost.model.Item;
import com.easypost.model.OrderCollection;
import com.easypost.model.Rate;
import com.easypost.model.Shipment;
import com.easypost.model.ShipmentMessage;
import com.easypost.net.EasyPostResource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Order
extends EasyPostResource {
    public String id;
    String mode;
    String reference;
    Boolean isReturn;
    Address toAddress;
    Address buyerAddress;
    Address fromAddress;
    Address returnAddress;
    CustomsInfo customsInfo;
    List<Shipment> shipments;
    List<Rate> rates;
    List<Container> containers;
    List<Item> items;
    Map<String, String> options;
    List<ShipmentMessage> messages;

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public Boolean getIsReturn() {
        return this.isReturn;
    }

    public void setIsReturn(Boolean isReturn) {
        this.isReturn = isReturn;
    }

    public Address getToAddress() {
        return this.toAddress;
    }

    public void setToAddress(Address toAddress) {
        this.toAddress = toAddress;
    }

    public Address getBuyerAddress() {
        return this.buyerAddress;
    }

    public void setBuyerAddress(Address buyerAddress) {
        this.buyerAddress = buyerAddress;
    }

    public Address getFromAddress() {
        return this.fromAddress;
    }

    public void setFromAddress(Address fromAddress) {
        this.fromAddress = fromAddress;
    }

    public Address getReturnAddress() {
        return this.returnAddress;
    }

    public void setReturnAddress(Address returnAddress) {
        this.returnAddress = returnAddress;
    }

    public CustomsInfo getCustomsInfo() {
        return this.customsInfo;
    }

    public void setCustomsInfo(CustomsInfo customsInfo) {
        this.customsInfo = customsInfo;
    }

    @Override
    public List<Shipment> getShipments() {
        return this.shipments;
    }

    public void setShipments(List<Shipment> shipments) {
        this.shipments = shipments;
    }

    public List<Rate> getRates() {
        return this.rates;
    }

    public void setRates(List<Rate> rates) {
        this.rates = rates;
    }

    public List<Container> getContainers() {
        return this.containers;
    }

    public void setContainers(List<Container> containers) {
        this.containers = containers;
    }

    public List<Item> getItems() {
        return this.items;
    }

    public void setItems(List<Item> items) {
        this.items = items;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, String> options) {
        this.options = options;
    }

    public List<ShipmentMessage> getMessages() {
        return this.messages;
    }

    public void setMessages(List<ShipmentMessage> messages) {
        this.messages = messages;
    }

    public static Order create(Map<String, Object> params) throws EasyPostException {
        return Order.create(params, null);
    }

    public static Order create(Map<String, Object> params, String apiKey) throws EasyPostException {
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        wrappedParams.put("order", params);
        return Order.request(EasyPostResource.RequestMethod.POST, Order.classURL(Order.class), wrappedParams, Order.class, apiKey);
    }

    public static Order retrieve(String id) throws EasyPostException {
        return Order.retrieve(id, null);
    }

    public static Order retrieve(String id, String apiKey) throws EasyPostException {
        return Order.request(EasyPostResource.RequestMethod.GET, Order.instanceURL(Order.class, id), null, Order.class, apiKey);
    }

    public static OrderCollection all(Map<String, Object> params) throws EasyPostException {
        return Order.all(params, null);
    }

    public static OrderCollection all(Map<String, Object> params, String apiKey) throws EasyPostException {
        return Order.request(EasyPostResource.RequestMethod.GET, Order.classURL(Order.class), params, OrderCollection.class, apiKey);
    }

    public Order refresh() throws EasyPostException {
        return this.refresh(null, null);
    }

    public Order refresh(Map<String, Object> params) throws EasyPostException {
        return this.refresh(params, null);
    }

    public Order refresh(String apiKey) throws EasyPostException {
        return this.refresh(null, apiKey);
    }

    public Order refresh(Map<String, Object> params, String apiKey) throws EasyPostException {
        return Order.request(EasyPostResource.RequestMethod.GET, String.format("%s", Order.instanceURL(Order.class, this.getId())), params, Order.class, apiKey);
    }

    public Order buy(Map<String, Object> params) throws EasyPostException {
        return this.buy(params, null);
    }

    public Order buy(Rate rate) throws EasyPostException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("carrier", rate.carrier);
        params.put("service", rate.service);
        return this.buy(params, null);
    }

    public Order buy(Map<String, Object> params, String apiKey) throws EasyPostException {
        Order response = Order.request(EasyPostResource.RequestMethod.POST, String.format("%s/buy", Order.instanceURL(Order.class, this.getId())), params, Order.class, apiKey);
        this.merge(this, response);
        return this;
    }
}

