/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.net;

import com.easypost.EasyPost;
import com.easypost.exception.EasyPostException;
import com.easypost.model.Event;
import com.easypost.model.EventDeserializer;
import com.easypost.model.Rate;
import com.easypost.model.RateDeserializer;
import com.easypost.model.Shipment;
import com.easypost.model.TrackingDetail;
import com.easypost.net.EasyPostResponse;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.URLStreamHandler;
import java.security.Security;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import javax.net.ssl.HttpsURLConnection;

public abstract class EasyPostResource {
    public static final Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapter(Event.class, (Object)new EventDeserializer()).registerTypeAdapter(Rate.class, (Object)new RateDeserializer()).create();
    public static final Gson prettyPrintGson = new GsonBuilder().setPrettyPrinting().serializeNulls().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapter(Event.class, (Object)new EventDeserializer()).create();
    public static final String CHARSET = "UTF-8";
    private static final String DNS_CACHE_TTL_PROPERTY_NAME = "networkaddress.cache.ttl";
    private static final String CUSTOM_URL_STREAM_HANDLER_PROPERTY_NAME = "com.easypost.net.customURLStreamHandler";

    public String toString() {
        return (String)this.getIdString();
    }

    public String prettyPrint() {
        return String.format("<%s@%s id=%s> JSON: %s", this.getClass().getName(), System.identityHashCode(this), this.getIdString(), prettyPrintGson.toJson((Object)this));
    }

    private Object getIdString() {
        try {
            Field idField = this.getClass().getDeclaredField("id");
            return idField.get(this);
        }
        catch (SecurityException e) {
            return "";
        }
        catch (NoSuchFieldException e) {
            return "";
        }
        catch (IllegalArgumentException e) {
            return "";
        }
        catch (IllegalAccessException e) {
            return "";
        }
    }

    private static String className(Class<?> clazz) {
        return clazz.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase().replace("$", "");
    }

    protected static String singleClassURL(Class<?> clazz) {
        return String.format("%s/%s", EasyPost.API_BASE, EasyPostResource.className(clazz));
    }

    protected static String classURL(Class<?> clazz) {
        String singleURL = EasyPostResource.singleClassURL(clazz);
        if (singleURL.charAt(singleURL.length() - 1) == 's' || singleURL.charAt(singleURL.length() - 1) == 'h') {
            return String.format("%ses", EasyPostResource.singleClassURL(clazz));
        }
        return String.format("%ss", EasyPostResource.singleClassURL(clazz));
    }

    protected static String instanceURL(Class<?> clazz, String id) {
        return String.format("%s/%s", EasyPostResource.classURL(clazz), id);
    }

    public void merge(EasyPostResource obj, EasyPostResource update) {
        Method[] methods;
        if (!obj.getClass().isAssignableFrom(update.getClass())) {
            return;
        }
        for (Method fromMethod : methods = obj.getClass().getMethods()) {
            if (!fromMethod.getDeclaringClass().equals(obj.getClass()) || !fromMethod.getName().startsWith("get")) continue;
            String fromName = fromMethod.getName();
            String toName = fromName.replace("get", "set");
            try {
                Object value = fromMethod.invoke((Object)update, (Object[])null);
                if (value == null) continue;
                Method toMethod = obj.getClass().getMethod(toName, fromMethod.getReturnType());
                toMethod.invoke((Object)obj, value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static String urlEncodePair(String k, String v) throws UnsupportedEncodingException {
        return String.format("%s=%s", URLEncoder.encode(k, CHARSET), URLEncoder.encode(v, CHARSET));
    }

    static Map<String, String> getHeaders(String apiKey) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept-Charset", CHARSET);
        headers.put("User-Agent", String.format("EasyPost/v2 JavaClient/%s", "3.4.0"));
        if (apiKey == null) {
            apiKey = EasyPost.apiKey;
        }
        headers.put("Authorization", String.format("Bearer %s", apiKey));
        String[] propertyNames = new String[]{"os.name", "os.version", "os.arch", "java.version", "java.vendor", "java.vm.version", "java.vm.vendor"};
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        for (String propertyName : propertyNames) {
            propertyMap.put(propertyName, System.getProperty(propertyName));
        }
        propertyMap.put("lang", "Java");
        propertyMap.put("publisher", "EasyPost");
        headers.put("X-Client-User-Agent", gson.toJson(propertyMap));
        return headers;
    }

    private static HttpsURLConnection createEasyPostConnection(String url, String apiKey) throws IOException {
        URL easypostURL = null;
        String customURLStreamHandlerClassName = System.getProperty(CUSTOM_URL_STREAM_HANDLER_PROPERTY_NAME, null);
        if (customURLStreamHandlerClassName != null) {
            try {
                Class<?> clazz = Class.forName(customURLStreamHandlerClassName);
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                URLStreamHandler customHandler = (URLStreamHandler)constructor.newInstance(new Object[0]);
                easypostURL = new URL(null, url, customHandler);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
            catch (SecurityException e) {
                throw new IOException(e);
            }
            catch (NoSuchMethodException e) {
                throw new IOException(e);
            }
            catch (IllegalArgumentException e) {
                throw new IOException(e);
            }
            catch (InstantiationException e) {
                throw new IOException(e);
            }
            catch (IllegalAccessException e) {
                throw new IOException(e);
            }
            catch (InvocationTargetException e) {
                throw new IOException(e);
            }
        } else {
            easypostURL = new URL(url);
        }
        HttpsURLConnection conn = (HttpsURLConnection)easypostURL.openConnection();
        conn.setConnectTimeout(20000);
        int readTimeout = EasyPost.readTimeout != 0 ? EasyPost.readTimeout : 40000;
        conn.setReadTimeout(readTimeout);
        conn.setUseCaches(false);
        for (Map.Entry<String, String> header : EasyPostResource.getHeaders(apiKey).entrySet()) {
            conn.setRequestProperty(header.getKey(), header.getValue());
        }
        return conn;
    }

    private static HttpsURLConnection createGetConnection(String url, String query, String apiKey) throws IOException {
        String getURL = String.format("%s?%s", url, query);
        HttpsURLConnection conn = EasyPostResource.createEasyPostConnection(getURL, apiKey);
        conn.setRequestMethod("GET");
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HttpsURLConnection createPostConnection(String url, String query, String apiKey) throws IOException {
        HttpsURLConnection conn = EasyPostResource.createEasyPostConnection(url, apiKey);
        conn.setDoOutput(true);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", String.format("application/x-www-form-urlencoded;charset=%s", CHARSET));
        try (OutputStream output = null;){
            output = conn.getOutputStream();
            output.write(query.getBytes(CHARSET));
        }
        return conn;
    }

    private static HttpsURLConnection createDeleteConnection(String url, String query, String apiKey) throws IOException {
        String deleteUrl = String.format("%s?%s", url, query);
        HttpsURLConnection conn = EasyPostResource.createEasyPostConnection(deleteUrl, apiKey);
        conn.setRequestMethod("DELETE");
        return conn;
    }

    private static HttpsURLConnection createPutConnection(String url, String query, String apiKey) throws IOException {
        String putUrl = String.format("%s?%s", url, query);
        HttpsURLConnection conn = EasyPostResource.createEasyPostConnection(putUrl, apiKey);
        conn.setRequestMethod("PUT");
        return conn;
    }

    private static String createQuery(Map<String, Object> params) throws UnsupportedEncodingException {
        Map<String, String> flatParams = EasyPostResource.flattenParams(params);
        StringBuffer queryStringBuffer = new StringBuffer();
        for (Map.Entry<String, String> entry : flatParams.entrySet()) {
            queryStringBuffer.append("&");
            queryStringBuffer.append(EasyPostResource.urlEncodePair(entry.getKey(), entry.getValue()));
        }
        if (queryStringBuffer.length() > 0) {
            queryStringBuffer.deleteCharAt(0);
        }
        return queryStringBuffer.toString();
    }

    private static Map<String, String> flattenParams(Map<String, Object> params) {
        if (params == null) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> flatParams = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            HashMap<String, Object> flatNestedMap;
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                flatNestedMap = new HashMap<String, Object>();
                Map nestedMap = (Map)value;
                for (Map.Entry nestedEntry : nestedMap.entrySet()) {
                    flatNestedMap.put(String.format("%s[%s]", key, nestedEntry.getKey()), nestedEntry.getValue());
                }
                flatParams.putAll(EasyPostResource.flattenParams(flatNestedMap));
                continue;
            }
            if (value instanceof List) {
                flatNestedMap = new HashMap();
                List nestedList = (List)value;
                for (int i = 0; i < nestedList.size(); ++i) {
                    flatNestedMap.put(String.format("%s[%s]", key, i), nestedList.get(i));
                    flatParams.putAll(EasyPostResource.flattenParams(flatNestedMap));
                }
                continue;
            }
            if (value instanceof EasyPostResource) {
                flatParams.put(String.format("%s[%s]", key, "id"), value.toString());
                continue;
            }
            if (value == null) continue;
            flatParams.put(key, value.toString());
        }
        return flatParams;
    }

    private static String getResponseBody(InputStream responseStream) throws IOException {
        String rBody = new Scanner(responseStream, CHARSET).useDelimiter("\\A").next();
        responseStream.close();
        return rBody;
    }

    private static EasyPostResponse makeURLConnectionRequest(RequestMethod method, String url, String query, String apiKey) throws EasyPostException {
        HttpURLConnection conn = null;
        try {
            switch (method) {
                case GET: {
                    conn = EasyPostResource.createGetConnection(url, query, apiKey);
                    break;
                }
                case POST: {
                    conn = EasyPostResource.createPostConnection(url, query, apiKey);
                    break;
                }
                case DELETE: {
                    conn = EasyPostResource.createDeleteConnection(url, query, apiKey);
                    break;
                }
                case PUT: {
                    conn = EasyPostResource.createPutConnection(url, query, apiKey);
                    break;
                }
                default: {
                    throw new EasyPostException(String.format("Unrecognized HTTP method %s. Please contact EasyPost at contact@easypost.com.", new Object[]{method}));
                }
            }
            int rCode = conn.getResponseCode();
            String rBody = null;
            rBody = rCode == 204 ? "" : (rCode >= 200 && rCode < 300 ? EasyPostResource.getResponseBody(conn.getInputStream()) : EasyPostResource.getResponseBody(conn.getErrorStream()));
            EasyPostResponse easyPostResponse = new EasyPostResponse(rCode, rBody);
            return easyPostResponse;
        }
        catch (IOException e) {
            throw new EasyPostException(String.format("Could not connect to EasyPost (%s). Please check your internet connection and try again. If this problem persists,please contact us at contact@easypost.com.", EasyPost.API_BASE), e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    protected static <T> T request(RequestMethod method, String url, Map<String, Object> params, Class<T> clazz, String apiKey) throws EasyPostException {
        return EasyPostResource.request(method, url, params, clazz, apiKey, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <T> T request(RequestMethod method, String url, Map<String, Object> params, Class<T> clazz, String apiKey, boolean apiKeyRequired) throws EasyPostException {
        String originalDNSCacheTTL = null;
        Boolean allowedToSetTTL = true;
        try {
            originalDNSCacheTTL = Security.getProperty(DNS_CACHE_TTL_PROPERTY_NAME);
            Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, "0");
        }
        catch (SecurityException se) {
            allowedToSetTTL = false;
        }
        try {
            T t = EasyPostResource._request(method, url, params, clazz, apiKey, apiKeyRequired);
            return t;
        }
        finally {
            if (allowedToSetTTL.booleanValue()) {
                if (originalDNSCacheTTL == null) {
                    Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, "-1");
                } else {
                    Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, originalDNSCacheTTL);
                }
            }
        }
    }

    protected static <T> T _request(RequestMethod method, String url, Map<String, Object> params, Class<T> clazz, String apiKey, boolean apiKeyRequired) throws EasyPostException {
        EasyPostResponse response;
        String query;
        if (!(EasyPost.apiKey != null && EasyPost.apiKey.length() != 0 || apiKey != null && apiKey.length() != 0 || !apiKeyRequired)) {
            throw new EasyPostException("No API key provided. (set your API key using 'EasyPost.apiKey = {KEY}'. Your API key can be found in your EasyPost dashboard, or you can email us at contact@easypost.com for assistance.");
        }
        if (apiKey == null) {
            apiKey = EasyPost.apiKey;
        }
        try {
            query = EasyPostResource.createQuery(params);
        }
        catch (UnsupportedEncodingException e) {
            throw new EasyPostException("Unable to encode parameters to UTF-8. Please email contact@easypost.com for assistance.", e);
        }
        try {
            response = EasyPostResource.makeURLConnectionRequest(method, url, query, apiKey);
        }
        catch (ClassCastException ce) {
            String appEngineEnv = System.getProperty("com.google.appengine.runtime.environment", null);
            if (appEngineEnv != null) {
                response = EasyPostResource.makeAppEngineRequest(method, url, query, apiKey);
            }
            throw ce;
        }
        int rCode = response.responseCode;
        String rBody = response.responseBody;
        if (rCode < 200 || rCode >= 300) {
            EasyPostResource.handleAPIError(rBody, rCode);
        }
        return (T)gson.fromJson(rBody, clazz);
    }

    private static void handleAPIError(String rBody, int rCode) throws EasyPostException {
        try {
            Error error = (Error)gson.fromJson(rBody, Error.class);
            if (error.error.length() > 0) {
                throw new EasyPostException(error.error);
            }
            throw new EasyPostException(error.message, error.param, null);
        }
        catch (Exception e) {
            throw new EasyPostException(String.format("An error occured. Response code: %s Response body: %s", rCode, rBody));
        }
    }

    private static EasyPostResponse makeAppEngineRequest(RequestMethod method, String url, String query, String apiKey) throws EasyPostException {
        String unknownErrorMessage = "Sorry, an unknown error occurred while trying to use the Google App Engine runtime. Please email contact@easypost.com for assistance.";
        try {
            if (method == RequestMethod.GET || method == RequestMethod.DELETE) {
                url = String.format("%s?%s", url, query);
            }
            URL fetchURL = new URL(url);
            Class<?> requestMethodClass = Class.forName("com.google.appengine.api.urlfetch.HTTPMethod");
            Object httpMethod = requestMethodClass.getDeclaredField(method.name()).get(null);
            Class<?> fetchOptionsBuilderClass = Class.forName("com.google.appengine.api.urlfetch.FetchOptions$Builder");
            Object fetchOptions = null;
            try {
                fetchOptions = fetchOptionsBuilderClass.getDeclaredMethod("validateCertificate", new Class[0]).invoke(null, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                System.err.println("Warning: this App Engine SDK version does not allow verification of SSL certificates;this exposes you to a MITM attack. Please upgrade your App Engine SDK to >=1.5.0. If you have questions, email contact@easypost.com.");
                fetchOptions = fetchOptionsBuilderClass.getDeclaredMethod("withDefaults", new Class[0]).invoke(null, new Object[0]);
            }
            Class<?> fetchOptionsClass = Class.forName("com.google.appengine.api.urlfetch.FetchOptions");
            fetchOptionsClass.getDeclaredMethod("setDeadline", Double.class).invoke(fetchOptions, new Double(20.0));
            Class<?> requestClass = Class.forName("com.google.appengine.api.urlfetch.HTTPRequest");
            Object request = requestClass.getDeclaredConstructor(URL.class, requestMethodClass, fetchOptionsClass).newInstance(fetchURL, httpMethod, fetchOptions);
            if (method == RequestMethod.POST) {
                requestClass.getDeclaredMethod("setPayload", byte[].class).invoke(request, new Object[]{query.getBytes()});
            }
            for (Map.Entry<String, String> header : EasyPostResource.getHeaders(apiKey).entrySet()) {
                Class<?> httpHeaderClass = Class.forName("com.google.appengine.api.urlfetch.HTTPHeader");
                Object reqHeader = httpHeaderClass.getDeclaredConstructor(String.class, String.class).newInstance(header.getKey(), header.getValue());
                requestClass.getDeclaredMethod("setHeader", httpHeaderClass).invoke(request, reqHeader);
            }
            Class<?> urlFetchFactoryClass = Class.forName("com.google.appengine.api.urlfetch.URLFetchServiceFactory");
            Object urlFetchService = urlFetchFactoryClass.getDeclaredMethod("getURLFetchService", new Class[0]).invoke(null, new Object[0]);
            Method fetchMethod = urlFetchService.getClass().getDeclaredMethod("fetch", requestClass);
            fetchMethod.setAccessible(true);
            Object response = fetchMethod.invoke(urlFetchService, request);
            int responseCode = (Integer)response.getClass().getDeclaredMethod("getResponseCode", new Class[0]).invoke(response, new Object[0]);
            String body = new String((byte[])response.getClass().getDeclaredMethod("getContent", new Class[0]).invoke(response, new Object[0]), CHARSET);
            return new EasyPostResponse(responseCode, body);
        }
        catch (InvocationTargetException e) {
            throw new EasyPostException(unknownErrorMessage, e);
        }
        catch (MalformedURLException e) {
            throw new EasyPostException(unknownErrorMessage, e);
        }
        catch (NoSuchFieldException e) {
            throw new EasyPostException(unknownErrorMessage, e);
        }
        catch (SecurityException e) {
            throw new EasyPostException(unknownErrorMessage, e);
        }
        catch (NoSuchMethodException e) {
            throw new EasyPostException(unknownErrorMessage, e);
        }
        catch (ClassNotFoundException e) {
            throw new EasyPostException(unknownErrorMessage, e);
        }
        catch (IllegalArgumentException e) {
            throw new EasyPostException(unknownErrorMessage, e);
        }
        catch (IllegalAccessException e) {
            throw new EasyPostException(unknownErrorMessage, e);
        }
        catch (InstantiationException e) {
            throw new EasyPostException(unknownErrorMessage, e);
        }
        catch (UnsupportedEncodingException e) {
            throw new EasyPostException(unknownErrorMessage, e);
        }
    }

    public String getId() {
        return "";
    }

    public String getMode() {
        return "";
    }

    public List<Shipment> getShipments() {
        return new ArrayList<Shipment>();
    }

    public String getLabelUrl() {
        return "";
    }

    public String getShipmentId() {
        return "";
    }

    public String getTrackingCode() {
        return "";
    }

    public String getStatus() {
        return "";
    }

    public List<TrackingDetail> getTrackingDetails() {
        return new ArrayList<TrackingDetail>();
    }

    private static class Error {
        String type;
        String message;
        String code;
        String param;
        String error;

        private Error() {
        }
    }

    private static class ErrorContainer {
        private Error error;

        private ErrorContainer() {
        }
    }

    protected static enum RequestMethod {
        GET,
        POST,
        DELETE,
        PUT;

    }
}

