/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.model;

import com.easypost.model.Address;
import com.easypost.model.Batch;
import com.easypost.model.CustomsInfo;
import com.easypost.model.CustomsItem;
import com.easypost.model.Event;
import com.easypost.model.Fee;
import com.easypost.model.Parcel;
import com.easypost.model.PostageLabel;
import com.easypost.model.Rate;
import com.easypost.model.Refund;
import com.easypost.model.ScanForm;
import com.easypost.model.Shipment;
import com.easypost.model.Tracker;
import com.easypost.model.TrackingDetail;
import com.easypost.model.Webhook;
import com.easypost.net.EasyPostResource;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class EventDeserializer
implements JsonDeserializer<Event> {
    static Map<String, Class> objectMap = new HashMap<String, Class>();

    private Object deserializeJsonPrimitive(JsonPrimitive element) {
        if (element.isBoolean()) {
            return element.getAsBoolean();
        }
        if (element.isNumber()) {
            return element.getAsNumber();
        }
        return element.getAsString();
    }

    private Object[] deserializeJsonArray(JsonArray arr) {
        Object[] elems = new Object[arr.size()];
        Iterator elemIter = arr.iterator();
        int i = 0;
        while (elemIter.hasNext()) {
            JsonElement elem = (JsonElement)elemIter.next();
            elems[i++] = this.deserializeJsonElement(elem);
        }
        return elems;
    }

    private Object deserializeJsonElement(JsonElement element) {
        if (element.isJsonNull()) {
            return null;
        }
        if (element.isJsonObject()) {
            HashMap<String, Object> valueMap = new HashMap<String, Object>();
            this.populateMapFromJSONObject(valueMap, element.getAsJsonObject());
            return valueMap;
        }
        if (element.isJsonPrimitive()) {
            return this.deserializeJsonPrimitive(element.getAsJsonPrimitive());
        }
        if (element.isJsonArray()) {
            return this.deserializeJsonArray(element.getAsJsonArray());
        }
        System.err.println("Unknown JSON element type for element " + element + ". Please email us at support@easypost.com.");
        return null;
    }

    private void populateMapFromJSONObject(Map<String, Object> objMap, JsonObject jsonObject) {
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement element = (JsonElement)entry.getValue();
            objMap.put(key, this.deserializeJsonElement(element));
        }
    }

    public Event deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Event event = new Event();
        JsonObject jsonObject = json.getAsJsonObject();
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement element = (JsonElement)entry.getValue();
            if ("previous_attributes".equals(key)) {
                HashMap<String, Object> previousAttributes = new HashMap<String, Object>();
                this.populateMapFromJSONObject(previousAttributes, element.getAsJsonObject());
                event.setPreviousAttributes(previousAttributes);
                continue;
            }
            if (!"result".equals(key)) continue;
            String type = element.getAsJsonObject().get("object").getAsString();
            Class cl = objectMap.get(type);
            EasyPostResource result = (EasyPostResource)EasyPostResource.gson.fromJson((JsonElement)entry.getValue(), cl);
            event.setResult(result);
        }
        event.setId(jsonObject.get("id").getAsString());
        event.setDescription(jsonObject.get("description").getAsString());
        event.setMode(jsonObject.get("mode").getAsString());
        return event;
    }

    static {
        objectMap.put("Address", Address.class);
        objectMap.put("Batch", Batch.class);
        objectMap.put("CustomsInfo", CustomsInfo.class);
        objectMap.put("CustomsItem", CustomsItem.class);
        objectMap.put("Event", Event.class);
        objectMap.put("Fee", Fee.class);
        objectMap.put("Parcel", Parcel.class);
        objectMap.put("PostageLabel", PostageLabel.class);
        objectMap.put("Rate", Rate.class);
        objectMap.put("Refund", Refund.class);
        objectMap.put("ScanForm", ScanForm.class);
        objectMap.put("Shipment", Shipment.class);
        objectMap.put("Tracker", Tracker.class);
        objectMap.put("TrackingDetail", TrackingDetail.class);
        objectMap.put("Webhook", Webhook.class);
    }
}

