/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.model;

import com.easypost.EasyPost;
import com.easypost.exception.EasyPostException;
import com.easypost.model.ReportCollection;
import com.easypost.net.EasyPostResource;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Report
extends EasyPostResource {
    public String id;
    Date startDate;
    Date endDate;
    String mode;
    String status;
    Boolean includeChildren;
    String url;
    Date urlExpiresAt;

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    @Override
    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Boolean getIncludeChildren() {
        return this.includeChildren;
    }

    public void setIncludeChildren(Boolean includeChildren) {
        this.includeChildren = includeChildren;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Date getUrlExpiresAt() {
        return this.urlExpiresAt;
    }

    public void setUrlExpiresAt(Date urlExpiresAt) {
        this.urlExpiresAt = urlExpiresAt;
    }

    public static Report create(Map<String, Object> params) throws EasyPostException {
        return Report.create(params, null);
    }

    public static Report create(Map<String, Object> params, String apiKey) throws EasyPostException {
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        wrappedParams.put("report", params);
        wrappedParams.put("start_date", params.get("start_date"));
        wrappedParams.put("end_date", params.get("end_date"));
        String type = (String)params.get("type");
        return Report.request(EasyPostResource.RequestMethod.POST, Report.reportURL(type), wrappedParams, Report.class, apiKey);
    }

    public static Report retrieve(String id) throws EasyPostException {
        return Report.retrieve(id, null);
    }

    public static Report retrieve(String id, String apiKey) throws EasyPostException {
        return Report.request(EasyPostResource.RequestMethod.GET, Report.instanceURL(Report.class, id), null, Report.class, apiKey);
    }

    public static ReportCollection all(Map<String, Object> params) throws EasyPostException {
        return Report.all(params, null);
    }

    public static ReportCollection all(Map<String, Object> params, String apiKey) throws EasyPostException {
        String type = (String)params.get("type");
        return Report.request(EasyPostResource.RequestMethod.GET, Report.reportURL(type), params, ReportCollection.class, apiKey);
    }

    protected static String reportURL(String type) throws EasyPostException {
        try {
            String urlType = URLEncoder.encode(type, "UTF-8").toLowerCase();
            return String.format("%s/reports/%s/", EasyPost.API_BASE, urlType);
        }
        catch (UnsupportedEncodingException e) {
            throw new EasyPostException("Undetermined Report Type");
        }
    }
}

