/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.model;

import com.easypost.exception.EasyPostException;
import com.easypost.model.AddressCollection;
import com.easypost.model.AddressVerification;
import com.easypost.model.AddressVerifyResponse;
import com.easypost.net.EasyPostResource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Address
extends EasyPostResource {
    public String id;
    String mode;
    String name;
    String company;
    String street1;
    String street2;
    String zip;
    String city;
    String state;
    String country;
    String phone;
    String email;
    String message;
    String carrierFacility;
    String federalTaxId;
    Boolean residential;
    Map<String, AddressVerification> verifications;

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getStreet1() {
        return this.street1;
    }

    public void setStreet1(String street1) {
        this.street1 = street1;
    }

    public String getStreet2() {
        return this.street2;
    }

    public void setStreet2(String street2) {
        this.street2 = street2;
    }

    public String getZip() {
        return this.zip;
    }

    public void setZip(String zip) {
        this.zip = zip;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getCarrierFacility() {
        return this.carrierFacility;
    }

    public void setCarrierFacility(String carrierFacility) {
        this.carrierFacility = carrierFacility;
    }

    public String getFederalTaxId() {
        return this.federalTaxId;
    }

    public void setFederalTaxId(String federalTaxId) {
        this.federalTaxId = federalTaxId;
    }

    public Boolean getResidential() {
        return this.residential;
    }

    public void setResidential(Boolean residential) {
        this.residential = residential;
    }

    public Map<String, AddressVerification> getVerifications() {
        return this.verifications;
    }

    public void setVerifications(Map<String, AddressVerification> verifications) {
        this.verifications = verifications;
    }

    public static Address create(Map<String, Object> params) throws EasyPostException {
        return Address.create(params, null);
    }

    public static Address create(Map<String, Object> params, String apiKey) throws EasyPostException {
        String url = Address.classURL(Address.class);
        List verifyList = (List)params.remove("verify");
        List verifyStrictList = (List)params.remove("verify_strict");
        if (verifyList != null && verifyList.size() >= 1 || verifyStrictList != null && verifyStrictList.size() >= 1) {
            url = url + "?";
            if (verifyList != null && verifyList.size() >= 1) {
                for (String verification : verifyList) {
                    url = url + "verify[]=" + verification + "&";
                }
            }
            if (verifyStrictList != null && verifyStrictList.size() >= 1) {
                for (String strictVerification : verifyStrictList) {
                    url = url + "verify_strict[]=" + strictVerification + "&";
                }
            }
        }
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        wrappedParams.put("address", params);
        return Address.request(EasyPostResource.RequestMethod.POST, url, wrappedParams, Address.class, apiKey);
    }

    public static Address retrieve(String id) throws EasyPostException {
        return Address.retrieve(id, null);
    }

    public static Address retrieve(String id, String apiKey) throws EasyPostException {
        return Address.request(EasyPostResource.RequestMethod.GET, Address.instanceURL(Address.class, id), null, Address.class, apiKey);
    }

    public static AddressCollection all(Map<String, Object> params) throws EasyPostException {
        return Address.all(params, null);
    }

    public static AddressCollection all(Map<String, Object> params, String apiKey) throws EasyPostException {
        return Address.request(EasyPostResource.RequestMethod.GET, Address.classURL(Address.class), params, AddressCollection.class, apiKey);
    }

    public static Address createAndVerify(Map<String, Object> params) throws EasyPostException {
        return Address.createAndVerify(params, null);
    }

    public static Address createAndVerify(Map<String, Object> params, String apiKey) throws EasyPostException {
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        wrappedParams.put("address", params);
        AddressVerifyResponse response = Address.request(EasyPostResource.RequestMethod.POST, String.format("%s/create_and_verify", Address.classURL(Address.class)), wrappedParams, AddressVerifyResponse.class, apiKey);
        if (response.message != null) {
            response.address.message = response.message;
        }
        return response.address;
    }

    public static Address createAndVerifyWithCarrier(Map<String, Object> params, String carrier) throws EasyPostException {
        return Address.createAndVerifyWithCarrier(params, carrier, null);
    }

    public static Address createAndVerifyWithCarrier(Map<String, Object> params, String carrier, String apiKey) throws EasyPostException {
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        wrappedParams.put("address", params);
        wrappedParams.put("carrier", carrier);
        AddressVerifyResponse response = Address.request(EasyPostResource.RequestMethod.POST, String.format("%s/create_and_verify", Address.classURL(Address.class)), wrappedParams, AddressVerifyResponse.class, apiKey);
        if (response.message != null) {
            response.address.message = response.message;
        }
        return response.address;
    }

    public Address verify() throws EasyPostException {
        return this.verify(null);
    }

    public Address verify(String apiKey) throws EasyPostException {
        AddressVerifyResponse response = Address.request(EasyPostResource.RequestMethod.GET, String.format("%s/verify", Address.instanceURL(Address.class, this.getId())), null, AddressVerifyResponse.class, apiKey);
        if (response.message != null) {
            response.address.message = response.message;
        }
        return response.address;
    }

    public Address verifyWithCarrier(String carrier) throws EasyPostException {
        return this.verifyWithCarrier(carrier, null);
    }

    public Address verifyWithCarrier(String carrier, String apiKey) throws EasyPostException {
        HashMap<String, String> wrappedParams = new HashMap<String, String>();
        wrappedParams.put("carrier", carrier);
        AddressVerifyResponse response = Address.request(EasyPostResource.RequestMethod.GET, String.format("%s/verify", Address.instanceURL(Address.class, this.getId())), null, AddressVerifyResponse.class, apiKey);
        if (response.message != null) {
            response.address.message = response.message;
        }
        return response.address;
    }
}

