/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.model;

import com.easypost.exception.EasyPostException;
import com.easypost.model.BatchCollection;
import com.easypost.model.BatchStatus;
import com.easypost.model.ScanForm;
import com.easypost.model.Shipment;
import com.easypost.net.EasyPostResource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Batch
extends EasyPostResource {
    public String id;
    String mode;
    String state;
    public BatchStatus status;
    Number numShipments;
    List<Shipment> shipments;
    String labelUrl;
    ScanForm scanForm;
    String reference;

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public Number getNumShipments() {
        return this.numShipments;
    }

    public void setNumShipments(Number numShipments) {
        this.numShipments = numShipments;
    }

    @Override
    public List<Shipment> getShipments() {
        return this.shipments;
    }

    public void setShipments(List<Shipment> shipments) {
        this.shipments = shipments;
    }

    @Override
    public String getLabelUrl() {
        return this.labelUrl;
    }

    public void setLabelUrl(String labelUrl) {
        this.labelUrl = labelUrl;
    }

    public ScanForm getScanForm() {
        return this.scanForm;
    }

    public void setScanForm(ScanForm scanForm) {
        this.scanForm = scanForm;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public static Batch create() throws EasyPostException {
        return Batch.create(null, null);
    }

    public static Batch create(Map<String, Object> params) throws EasyPostException {
        return Batch.create(params, null);
    }

    public static Batch create(Map<String, Object> params, String apiKey) throws EasyPostException {
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        wrappedParams.put("batch", params);
        return Batch.request(EasyPostResource.RequestMethod.POST, Batch.classURL(Batch.class), wrappedParams, Batch.class, apiKey);
    }

    public static Batch retrieve(String id) throws EasyPostException {
        return Batch.retrieve(id, null);
    }

    public static Batch retrieve(String id, String apiKey) throws EasyPostException {
        return Batch.request(EasyPostResource.RequestMethod.GET, Batch.instanceURL(Batch.class, id), null, Batch.class, apiKey);
    }

    public static BatchCollection all(Map<String, Object> params) throws EasyPostException {
        return Batch.all(params, null);
    }

    public static BatchCollection all(Map<String, Object> params, String apiKey) throws EasyPostException {
        return Batch.request(EasyPostResource.RequestMethod.GET, Batch.classURL(Batch.class), params, BatchCollection.class, apiKey);
    }

    public static Batch create_and_buy(Map<String, Object> params) throws EasyPostException {
        return Batch.create_and_buy(params, null);
    }

    public static Batch create_and_buy(Map<String, Object> params, String apiKey) throws EasyPostException {
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        wrappedParams.put("batch", params);
        return Batch.request(EasyPostResource.RequestMethod.POST, Batch.classURL(Batch.class), wrappedParams, Batch.class, apiKey);
    }

    public Batch refresh() throws EasyPostException {
        return this.refresh(null, null);
    }

    public Batch refresh(Map<String, Object> params) throws EasyPostException {
        return this.refresh(params, null);
    }

    public Batch refresh(String apiKey) throws EasyPostException {
        return this.refresh(null, apiKey);
    }

    public Batch refresh(Map<String, Object> params, String apiKey) throws EasyPostException {
        return Batch.request(EasyPostResource.RequestMethod.GET, String.format("%s", Batch.instanceURL(Batch.class, this.getId())), params, Batch.class, apiKey);
    }

    public Batch label() throws EasyPostException {
        return this.label(null, null);
    }

    public Batch label(Map<String, Object> params) throws EasyPostException {
        return this.label(params, null);
    }

    public Batch label(Map<String, Object> params, String apiKey) throws EasyPostException {
        return Batch.request(EasyPostResource.RequestMethod.POST, String.format("%s/label", Batch.instanceURL(Batch.class, this.getId())), params, Batch.class, apiKey);
    }

    public Batch addShipments(List<Shipment> shipments) throws EasyPostException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shipments", shipments);
        return this.addShipments(params, null);
    }

    public Batch addShipments(List<Shipment> shipments, String apiKey) throws EasyPostException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shipments", shipments);
        return this.addShipments(params, apiKey);
    }

    public Batch addShipments(Map<String, Object> params) throws EasyPostException {
        return this.addShipments(params, null);
    }

    public Batch addShipments(Map<String, Object> params, String apiKey) throws EasyPostException {
        return Batch.request(EasyPostResource.RequestMethod.POST, String.format("%s/add_shipments", Batch.instanceURL(Batch.class, this.getId())), params, Batch.class, apiKey);
    }

    public Batch removeShipments(List<Shipment> shipments) throws EasyPostException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shipments", shipments);
        return this.removeShipments(params, null);
    }

    public Batch removeShipments(List<Shipment> shipments, String apiKey) throws EasyPostException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shipments", shipments);
        return this.removeShipments(params, apiKey);
    }

    public Batch removeShipments(Map<String, Object> params) throws EasyPostException {
        return this.removeShipments(params, null);
    }

    public Batch removeShipments(Map<String, Object> params, String apiKey) throws EasyPostException {
        return Batch.request(EasyPostResource.RequestMethod.POST, String.format("%s/remove_shipments", Batch.instanceURL(Batch.class, this.getId())), params, Batch.class, apiKey);
    }

    public Batch buy() throws EasyPostException {
        return this.buy(null, null);
    }

    public Batch buy(Map<String, Object> params) throws EasyPostException {
        return this.buy(params, null);
    }

    public Batch buy(Map<String, Object> params, String apiKey) throws EasyPostException {
        return Batch.request(EasyPostResource.RequestMethod.POST, String.format("%s/buy", Batch.instanceURL(Batch.class, this.getId())), params, Batch.class, apiKey);
    }

    public Batch createScanForm() throws EasyPostException {
        return this.createScanForm(null, null);
    }

    public Batch createScanForm(Map<String, Object> params) throws EasyPostException {
        return this.createScanForm(params, null);
    }

    public Batch createScanForm(Map<String, Object> params, String apiKey) throws EasyPostException {
        return Batch.request(EasyPostResource.RequestMethod.POST, String.format("%s/scan_form", Batch.instanceURL(Batch.class, this.getId())), params, Batch.class, apiKey);
    }
}

