/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.model;

import com.easypost.exception.EasyPostException;
import com.easypost.model.Address;
import com.easypost.model.CustomsInfo;
import com.easypost.model.Rate;
import com.easypost.model.Shipment;
import com.easypost.model.ShipmentMessage;
import com.easypost.net.EasyPostResource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Order
extends EasyPostResource {
    private String id;
    private String mode;
    private String reference;
    private Boolean isReturn;
    private Address toAddress;
    private Address buyerAddress;
    private Address fromAddress;
    private Address returnAddress;
    private CustomsInfo customsInfo;
    private List<Shipment> shipments;
    private List<Rate> rates;
    private Map<String, Object> options;
    private List<ShipmentMessage> messages;

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public Boolean getIsReturn() {
        return this.isReturn;
    }

    public void setIsReturn(Boolean isReturn) {
        this.isReturn = isReturn;
    }

    public Address getToAddress() {
        return this.toAddress;
    }

    public void setToAddress(Address toAddress) {
        this.toAddress = toAddress;
    }

    public Address getBuyerAddress() {
        return this.buyerAddress;
    }

    public void setBuyerAddress(Address buyerAddress) {
        this.buyerAddress = buyerAddress;
    }

    public Address getFromAddress() {
        return this.fromAddress;
    }

    public void setFromAddress(Address fromAddress) {
        this.fromAddress = fromAddress;
    }

    public Address getReturnAddress() {
        return this.returnAddress;
    }

    public void setReturnAddress(Address returnAddress) {
        this.returnAddress = returnAddress;
    }

    public CustomsInfo getCustomsInfo() {
        return this.customsInfo;
    }

    public void setCustomsInfo(CustomsInfo customsInfo) {
        this.customsInfo = customsInfo;
    }

    @Override
    public List<Shipment> getShipments() {
        return this.shipments;
    }

    public void setShipments(List<Shipment> shipments) {
        this.shipments = shipments;
    }

    public List<Rate> getRates() {
        return this.rates;
    }

    public void setRates(List<Rate> rates) {
        this.rates = rates;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, Object> options) {
        this.options = options;
    }

    public List<ShipmentMessage> getMessages() {
        return this.messages;
    }

    public void setMessages(List<ShipmentMessage> messages) {
        this.messages = messages;
    }

    public static Order create(Map<String, Object> params) throws EasyPostException {
        return Order.create(params, null);
    }

    public static Order create(Map<String, Object> params, String apiKey) throws EasyPostException {
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        wrappedParams.put("order", params);
        return Order.request(EasyPostResource.RequestMethod.POST, Order.classURL(Order.class), wrappedParams, Order.class, apiKey);
    }

    public static Order retrieve(String id) throws EasyPostException {
        return Order.retrieve(id, null);
    }

    public static Order retrieve(String id, String apiKey) throws EasyPostException {
        return Order.request(EasyPostResource.RequestMethod.GET, Order.instanceURL(Order.class, id), null, Order.class, apiKey);
    }

    public Order refresh() throws EasyPostException {
        return this.refresh(null, null);
    }

    public Order refresh(Map<String, Object> params) throws EasyPostException {
        return this.refresh(params, null);
    }

    public Order refresh(String apiKey) throws EasyPostException {
        return this.refresh(null, apiKey);
    }

    public Order refresh(Map<String, Object> params, String apiKey) throws EasyPostException {
        return Order.request(EasyPostResource.RequestMethod.GET, String.format("%s", Order.instanceURL(Order.class, this.getId())), params, Order.class, apiKey);
    }

    public Order newRates() throws EasyPostException {
        return this.newRates(null, null);
    }

    public Order newRates(Map<String, Object> params) throws EasyPostException {
        return this.newRates(params, null);
    }

    public Order newRates(String apiKey) throws EasyPostException {
        return this.newRates(null, apiKey);
    }

    public Order newRates(Map<String, Object> params, String apiKey) throws EasyPostException {
        Order response = Order.request(EasyPostResource.RequestMethod.GET, String.format("%s/rates", Order.instanceURL(Order.class, this.getId())), params, Order.class, apiKey);
        this.merge(this, response);
        return this;
    }

    public Order buy(Map<String, Object> params) throws EasyPostException {
        return this.buy(params, null);
    }

    public Order buy(Rate rate) throws EasyPostException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("carrier", rate.getCarrier());
        params.put("service", rate.getService());
        return this.buy(params, null);
    }

    public Order buy(Map<String, Object> params, String apiKey) throws EasyPostException {
        Order response = Order.request(EasyPostResource.RequestMethod.POST, String.format("%s/buy", Order.instanceURL(Order.class, this.getId())), params, Order.class, apiKey);
        this.merge(this, response);
        return this;
    }
}

