/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.model;

import com.easypost.model.Rate;
import com.easypost.model.TimeInTransit;
import com.easypost.net.EasyPostResource;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;

public final class RateDeserializer
implements JsonDeserializer<Rate> {
    public Rate deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jo = (JsonObject)json;
        JsonElement currencyJsonElement = jo.get("currency");
        String currency = currencyJsonElement == null || currencyJsonElement.isJsonNull() ? null : jo.get("currency").getAsString();
        JsonElement listRateJsonElement = jo.get("list_rate");
        Float listRate = listRateJsonElement == null || listRateJsonElement.isJsonNull() ? null : Float.valueOf(jo.get("list_rate").getAsFloat());
        JsonElement listCurrencyJsonElement = jo.get("list_currency");
        String listCurrency = listCurrencyJsonElement == null || listCurrencyJsonElement.isJsonNull() ? null : jo.get("list_currency").getAsString();
        JsonElement retailRateJsonElement = jo.get("retail_rate");
        Float retailRate = retailRateJsonElement == null || retailRateJsonElement.isJsonNull() ? null : Float.valueOf(jo.get("retail_rate").getAsFloat());
        JsonElement retailCurrencyJsonElement = jo.get("retail_currency");
        String retailCurrency = retailCurrencyJsonElement == null || retailCurrencyJsonElement.isJsonNull() ? null : jo.get("retail_currency").getAsString();
        JsonElement deliveryDaysJsonElement = jo.get("delivery_days");
        Number deliveryDays = deliveryDaysJsonElement == null || deliveryDaysJsonElement.isJsonNull() ? (Number)null : (Number)jo.get("delivery_days").getAsNumber();
        JsonElement deliveryDateJsonElement = jo.get("delivery_date");
        String deliveryDate = deliveryDateJsonElement == null || deliveryDateJsonElement.isJsonNull() ? null : jo.get("delivery_date").getAsString();
        JsonElement deliveryDateGuaranteedJsonElement = jo.get("delivery_date_guaranteed");
        Boolean deliveryDateGuaranteed = deliveryDateGuaranteedJsonElement == null || deliveryDateGuaranteedJsonElement.isJsonNull() ? Boolean.valueOf(false) : new Boolean(jo.get("delivery_date_guaranteed").getAsString());
        JsonElement estDeliveryDaysJsonElement = jo.get("est_delivery_days");
        Number estDeliveryDays = estDeliveryDaysJsonElement == null || estDeliveryDaysJsonElement.isJsonNull() ? (Number)null : (Number)jo.get("est_delivery_days").getAsNumber();
        JsonElement shipmentIdJsonElement = jo.get("shipment_id");
        String shipmentID = shipmentIdJsonElement == null || shipmentIdJsonElement.isJsonNull() ? null : jo.get("shipment_id").getAsString();
        JsonElement timeInTransitJsonElement = jo.get("time_in_transit");
        TimeInTransit timeInTransit = timeInTransitJsonElement == null || timeInTransitJsonElement.isJsonNull() ? null : (TimeInTransit)EasyPostResource.GSON.fromJson(timeInTransitJsonElement, TimeInTransit.class);
        Rate rate = new Rate();
        rate.setId(jo.get("id").getAsString());
        String carrier = jo.get("carrier").getAsString();
        rate.setCarrier(carrier);
        String service = jo.get("service").getAsString();
        rate.setService(service);
        rate.setServiceCode(carrier.toLowerCase() + "." + service.toLowerCase());
        rate.setRate(Float.valueOf(jo.get("rate").getAsFloat()));
        rate.setCurrency(currency);
        rate.setListRate(listRate);
        rate.setListCurrency(listCurrency);
        rate.setRetailRate(retailRate);
        rate.setRetailCurrency(retailCurrency);
        rate.setDeliveryDays(deliveryDays);
        rate.setDeliveryDate(deliveryDate);
        rate.setDeliveryDateGuaranteed(deliveryDateGuaranteed);
        rate.setEstDeliveryDays(estDeliveryDays);
        rate.setShipmentId(shipmentID);
        rate.setCarrierAccountId(jo.get("carrier_account_id").getAsString());
        rate.setTimeInTransit(timeInTransit);
        return rate;
    }
}

