/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.model;

import com.easypost.exception.EasyPostException;
import com.easypost.model.ApiKey;
import com.easypost.model.ApiKeys;
import com.easypost.net.EasyPostResource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class User
extends EasyPostResource {
    private String id;
    private String name;
    private String email;
    private String phoneNumber;
    private String balance;
    private String rechargeAmount;
    private String secondaryRechargeAmount;
    private String rechargeThreshold;
    private List<User> children;

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public String getBalance() {
        return this.balance;
    }

    public void setBalance(String balance) {
        this.balance = balance;
    }

    public String getRechargeAmount() {
        return this.rechargeAmount;
    }

    public void setRechargeAmount(String rechargeAmount) {
        this.rechargeAmount = rechargeAmount;
    }

    public String getSecondaryRechargeAmount() {
        return this.secondaryRechargeAmount;
    }

    public void setSecondaryRechargeAmount(String secondaryRechargeAmount) {
        this.secondaryRechargeAmount = secondaryRechargeAmount;
    }

    public String getRechargeThreshold() {
        return this.rechargeThreshold;
    }

    public void setRechargeThreshold(String rechargeThreshold) {
        this.rechargeThreshold = rechargeThreshold;
    }

    public List<User> getChildren() {
        return this.children;
    }

    public void setChildren(List<User> children) {
        this.children = children;
    }

    public static User retrieve(String id) throws EasyPostException {
        return User.retrieve(id, null);
    }

    public static User retrieve(String id, String apiKey) throws EasyPostException {
        return User.request(EasyPostResource.RequestMethod.GET, User.instanceURL(User.class, id), null, User.class, apiKey);
    }

    public static User retrieveMe() throws EasyPostException {
        return User.retrieveMe(null);
    }

    public static User retrieveMe(String apiKey) throws EasyPostException {
        return User.request(EasyPostResource.RequestMethod.GET, User.classURL(User.class), null, User.class, apiKey);
    }

    public static User create() throws EasyPostException {
        return User.create(null, null);
    }

    public static User create(Map<String, Object> params) throws EasyPostException {
        return User.create(params, null);
    }

    public static User create(Map<String, Object> params, String apiKey) throws EasyPostException {
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        wrappedParams.put("user", params);
        return User.request(EasyPostResource.RequestMethod.POST, User.classURL(User.class), wrappedParams, User.class, apiKey, false);
    }

    public User update(Map<String, Object> params) throws EasyPostException {
        return this.update(params, null);
    }

    public User update(Map<String, Object> params, String apiKey) throws EasyPostException {
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        wrappedParams.put("user", params);
        User response = User.request(EasyPostResource.RequestMethod.PUT, User.instanceURL(User.class, this.getId()), wrappedParams, User.class, apiKey);
        this.merge(this, response);
        return this;
    }

    public void delete() throws EasyPostException {
        this.delete(null);
    }

    public void delete(String apiKey) throws EasyPostException {
        User.request(EasyPostResource.RequestMethod.DELETE, User.instanceURL(User.class, this.getId()), null, User.class, apiKey);
    }

    public List<ApiKey> apiKeys() throws EasyPostException {
        ApiKeys parentKeys = ApiKeys.all();
        if (Objects.equals(this.getId(), parentKeys.getId())) {
            return parentKeys.getKeys();
        }
        for (int i = 0; i < parentKeys.getChildren().size(); ++i) {
            if (!this.getId().equals(parentKeys.getChildren().get(i).getId())) continue;
            return parentKeys.getChildren().get(i).getKeys();
        }
        throw new EasyPostException(String.format("Unable to find api key. Please contact %s.", "support@easypost.com"));
    }
}

