/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.model;

import com.easypost.exception.EasyPostException;
import com.easypost.model.ApiKey;
import com.easypost.model.BaseUser;
import com.easypost.model.PaymentMethod;
import com.easypost.model.PaymentMethodObject;
import com.easypost.model.ReferralCustomerCollection;
import com.easypost.model.Utilities;
import com.easypost.net.EasyPostResource;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReferralCustomer
extends BaseUser {
    private List<ApiKey> apiKeys;

    public List<ApiKey> getApiKeys() {
        return this.apiKeys;
    }

    public void setApiKeys(List<ApiKey> apiKeys) {
        this.apiKeys = apiKeys;
    }

    public static ReferralCustomer create(Map<String, Object> params) throws EasyPostException {
        return ReferralCustomer.create(params, null);
    }

    public static ReferralCustomer create(Map<String, Object> params, String apiKey) throws EasyPostException {
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        wrappedParams.put("user", params);
        return ReferralCustomer.request(EasyPostResource.RequestMethod.POST, String.format("%s/%s", "https://api.easypost.com/v2", "referral_customers"), wrappedParams, ReferralCustomer.class, apiKey);
    }

    public static boolean updateEmail(String email, String userId) throws EasyPostException {
        return ReferralCustomer.updateEmail(email, userId, null);
    }

    public static boolean updateEmail(String email, String userId, String apiKey) throws EasyPostException {
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("email", email);
        wrappedParams.put("user", params);
        ReferralCustomer.request(EasyPostResource.RequestMethod.PUT, String.format("%s/%s/%s", "https://api.easypost.com/v2", "referral_customers", userId), wrappedParams, ReferralCustomer.class, apiKey);
        return true;
    }

    public static ReferralCustomerCollection all(Map<String, Object> params) throws EasyPostException {
        return ReferralCustomer.all(params, null);
    }

    public static ReferralCustomerCollection all(Map<String, Object> params, String apiKey) throws EasyPostException {
        return ReferralCustomer.request(EasyPostResource.RequestMethod.GET, String.format("%s/%s", "https://api.easypost.com/v2", "referral_customers"), params, ReferralCustomerCollection.class, apiKey);
    }

    public static PaymentMethodObject addCreditCardToUser(String referralApiKey, String number, int expirationMonth, int expirationYear, String cvc) throws Exception {
        return ReferralCustomer.addCreditCardToUser(referralApiKey, number, expirationMonth, expirationYear, cvc, PaymentMethod.Priority.PRIMARY);
    }

    public static PaymentMethodObject addCreditCardToUser(String referralApiKey, String number, int expirationMonth, int expirationYear, String cvc, PaymentMethod.Priority priority) throws Exception {
        String stripeToken;
        String easypostStripeApiKey = ReferralCustomer.retrieveEasypostStripeApiKey();
        try {
            stripeToken = ReferralCustomer.createStripeToken(number, expirationMonth, expirationYear, cvc, easypostStripeApiKey);
        }
        catch (Exception e) {
            throw new Exception("Could not send card details to Stripe, please try again later", e);
        }
        return ReferralCustomer.createEasypostCreditCard(referralApiKey, stripeToken, priority.toString().toLowerCase());
    }

    private static String retrieveEasypostStripeApiKey() throws EasyPostException {
        Map response = ReferralCustomer.request(EasyPostResource.RequestMethod.GET, String.format("%s/%s", "https://api.easypost.com/v2", "partners/stripe_public_key"), null, Map.class, null);
        return response.getOrDefault("public_key", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String createStripeToken(String number, int expirationMonth, int expirationYear, String cvc, String easypostStripeApiKey) throws Exception {
        StringBuilder response;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("number", number);
        params.put("exp_month", String.valueOf(expirationMonth));
        params.put("exp_year", String.valueOf(expirationYear));
        params.put("cvc", cvc);
        URL stripeUrl = new URL("https://api.stripe.com/v1/tokens");
        HttpURLConnection conn = (HttpURLConnection)stripeUrl.openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Authorization", String.format("%s %s", "Bearer", easypostStripeApiKey));
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        conn.setDoOutput(true);
        String encodedURL = Utilities.getEncodedURL(params, "card");
        byte[] postData = encodedURL.getBytes(StandardCharsets.UTF_8);
        try (DataOutputStream wr = new DataOutputStream(conn.getOutputStream());){
            wr.write(postData);
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
            String line;
            response = new StringBuilder();
            while ((line = br.readLine()) != null) {
                response.append(line);
                response.append(System.lineSeparator());
            }
            br.close();
        }
        finally {
            conn.disconnect();
        }
        String responseBody = response.toString();
        Map responseMap = (Map)GSON.fromJson(responseBody, Map.class);
        return responseMap.get("id").toString();
    }

    private static PaymentMethodObject createEasypostCreditCard(String referralApiKey, String stripeObjectId, String priority) throws EasyPostException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("stripe_object_id", stripeObjectId);
        params.put("priority", priority);
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        wrappedParams.put("credit_card", params);
        return ReferralCustomer.request(EasyPostResource.RequestMethod.POST, String.format("%s/%s", "https://api.easypost.com/v2", "credit_cards"), wrappedParams, PaymentMethodObject.class, referralApiKey);
    }
}

