/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.model;

import com.easypost.exception.EasyPostException;
import com.easypost.model.Address;
import com.easypost.model.CarrierAccount;
import com.easypost.model.CustomsInfo;
import com.easypost.model.Form;
import com.easypost.model.Parcel;
import com.easypost.model.PostageLabel;
import com.easypost.model.Rate;
import com.easypost.model.ScanForm;
import com.easypost.model.ShipmentCollection;
import com.easypost.model.ShipmentMessage;
import com.easypost.model.Smartrate;
import com.easypost.model.SmartrateAccuracy;
import com.easypost.model.SmartrateCollection;
import com.easypost.model.TaxIdentifier;
import com.easypost.model.Tracker;
import com.easypost.model.Utilities;
import com.easypost.net.EasyPostResource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Shipment
extends EasyPostResource {
    private String id;
    private String mode;
    private String reference;
    private Boolean isReturn;
    private Address toAddress;
    private Address buyerAddress;
    private Address fromAddress;
    private Address returnAddress;
    private Parcel parcel;
    private CustomsInfo customsInfo;
    private Rate selectedRate;
    private List<Rate> rates;
    private PostageLabel postageLabel;
    private ScanForm scanForm;
    private String orderId;
    private List<Form> forms;
    private Tracker tracker;
    private String insurance;
    private String trackingCode;
    private String status;
    private String refundStatus;
    private String batchId;
    private String batchStatus;
    private String batchMessage;
    private String uspsZone;
    private Map<String, Object> options;
    private List<ShipmentMessage> messages;
    private List<TaxIdentifier> taxIdentifiers;
    private List<CarrierAccount> carrierAccounts;
    private String service;

    public String getBatchId() {
        return this.batchId;
    }

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    public String getBatchMessage() {
        return this.batchMessage;
    }

    public void setBatchMessage(String batchMessage) {
        this.batchMessage = batchMessage;
    }

    public String getBatchStatus() {
        return this.batchStatus;
    }

    public void setBatchStatus(String batchStatus) {
        this.batchStatus = batchStatus;
    }

    public Address getBuyerAddress() {
        return this.buyerAddress;
    }

    public void setBuyerAddress(Address buyerAddress) {
        this.buyerAddress = buyerAddress;
    }

    public List<CarrierAccount> getCarrierAccounts() {
        return this.carrierAccounts;
    }

    public void setCarrierAccounts(List<CarrierAccount> carrierAccounts) {
        this.carrierAccounts = carrierAccounts;
    }

    public CustomsInfo getCustomsInfo() {
        return this.customsInfo;
    }

    public void setCustomsInfo(CustomsInfo customsInfo) {
        this.customsInfo = customsInfo;
    }

    public List<Form> getForms() {
        return this.forms;
    }

    public void setForms(List<Form> forms) {
        this.forms = forms;
    }

    public Address getFromAddress() {
        return this.fromAddress;
    }

    public void setFromAddress(Address fromAddress) {
        this.fromAddress = fromAddress;
    }

    public String getInsurance() {
        return this.insurance;
    }

    public void setInsurance(String insurance) {
        this.insurance = insurance;
    }

    public Boolean getIsReturn() {
        return this.isReturn;
    }

    public void setIsReturn(Boolean isReturn) {
        this.isReturn = isReturn;
    }

    public List<ShipmentMessage> getMessages() {
        return this.messages;
    }

    public void setMessages(List<ShipmentMessage> messages) {
        this.messages = messages;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, Object> options) {
        this.options = options;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public Parcel getParcel() {
        return this.parcel;
    }

    public void setParcel(Parcel parcel) {
        this.parcel = parcel;
    }

    public PostageLabel getPostageLabel() {
        return this.postageLabel;
    }

    public void setPostageLabel(PostageLabel postageLabel) {
        this.postageLabel = postageLabel;
    }

    public List<Rate> getRates() {
        return this.rates;
    }

    public void setRates(List<Rate> rates) {
        this.rates = rates;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getRefundStatus() {
        return this.refundStatus;
    }

    public void setRefundStatus(String refundStatus) {
        this.refundStatus = refundStatus;
    }

    public Address getReturnAddress() {
        return this.returnAddress;
    }

    public void setReturnAddress(Address returnAddress) {
        this.returnAddress = returnAddress;
    }

    public ScanForm getScanForm() {
        return this.scanForm;
    }

    public void setScanForm(ScanForm scanForm) {
        this.scanForm = scanForm;
    }

    public Rate getSelectedRate() {
        return this.selectedRate;
    }

    public void setSelectedRate(Rate selectedRate) {
        this.selectedRate = selectedRate;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public List<TaxIdentifier> getTaxIdentifiers() {
        return this.taxIdentifiers;
    }

    public void setTaxIdentifiers(List<TaxIdentifier> taxIdentifiers) {
        this.taxIdentifiers = taxIdentifiers;
    }

    public Address getToAddress() {
        return this.toAddress;
    }

    public void setToAddress(Address toAddress) {
        this.toAddress = toAddress;
    }

    public Tracker getTracker() {
        return this.tracker;
    }

    public void setTracker(Tracker tracker) {
        this.tracker = tracker;
    }

    public String getUspsZone() {
        return this.uspsZone;
    }

    public void setUspsZone(String uspsZone) {
        this.uspsZone = uspsZone;
    }

    public static Shipment create(Map<String, Object> params) throws EasyPostException {
        return Shipment.create(params, null);
    }

    public static Shipment create(Map<String, Object> params, boolean withCarbonOffset) throws EasyPostException {
        return Shipment.create(params, withCarbonOffset, null);
    }

    public static Shipment create(Map<String, Object> params, String apiKey) throws EasyPostException {
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        wrappedParams.put("shipment", params);
        return Shipment.request(EasyPostResource.RequestMethod.POST, Shipment.classURL(Shipment.class), wrappedParams, Shipment.class, apiKey);
    }

    public static Shipment create(Map<String, Object> params, boolean withCarbonOffset, String apiKey) throws EasyPostException {
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        wrappedParams.put("shipment", params);
        wrappedParams.put("carbon_offset", withCarbonOffset);
        return Shipment.request(EasyPostResource.RequestMethod.POST, Shipment.classURL(Shipment.class), wrappedParams, Shipment.class, apiKey);
    }

    public static Shipment retrieve(String id) throws EasyPostException {
        return Shipment.retrieve(id, null);
    }

    public static Shipment retrieve(String id, String apiKey) throws EasyPostException {
        return Shipment.request(EasyPostResource.RequestMethod.GET, Shipment.instanceURL(Shipment.class, id), null, Shipment.class, apiKey);
    }

    public static ShipmentCollection all(Map<String, Object> params) throws EasyPostException {
        return Shipment.all(params, null);
    }

    public static ShipmentCollection all(Map<String, Object> params, String apiKey) throws EasyPostException {
        return Shipment.request(EasyPostResource.RequestMethod.GET, Shipment.classURL(Shipment.class), params, ShipmentCollection.class, apiKey);
    }

    public Shipment refresh() throws EasyPostException {
        return this.refresh(null, null);
    }

    public Shipment refresh(Map<String, Object> params, String apiKey) throws EasyPostException {
        return Shipment.request(EasyPostResource.RequestMethod.GET, String.format("%s", Shipment.instanceURL(Shipment.class, this.getId())), params, Shipment.class, apiKey);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public String getTrackingCode() {
        return this.trackingCode;
    }

    public void setTrackingCode(String trackingCode) {
        this.trackingCode = trackingCode;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Shipment refresh(Map<String, Object> params) throws EasyPostException {
        return this.refresh(params, null);
    }

    public Shipment refresh(String apiKey) throws EasyPostException {
        return this.refresh(null, apiKey);
    }

    public Shipment newRates() throws EasyPostException {
        return this.newRates((Map<String, Object>)new HashMap<String, Object>(){}, false, null);
    }

    public Shipment newRates(boolean withCarbonOffset) throws EasyPostException {
        return this.newRates((Map<String, Object>)new HashMap<String, Object>(){}, withCarbonOffset, null);
    }

    public Shipment newRates(Map<String, Object> params) throws EasyPostException {
        return this.newRates(params, false, null);
    }

    public Shipment newRates(Map<String, Object> params, boolean withCarbonOffset) throws EasyPostException {
        return this.newRates(params, withCarbonOffset, null);
    }

    public Shipment newRates(String apiKey) throws EasyPostException {
        return this.newRates((Map<String, Object>)new HashMap<String, Object>(){}, false, apiKey);
    }

    public Shipment newRates(boolean withCarbonOffset, String apiKey) throws EasyPostException {
        return this.newRates((Map<String, Object>)new HashMap<String, Object>(){}, withCarbonOffset, apiKey);
    }

    public Shipment newRates(Map<String, Object> params, String apiKey) throws EasyPostException {
        return this.newRates(params, false, apiKey);
    }

    public Shipment newRates(Map<String, Object> params, boolean withCarbonOffset, String apiKey) throws EasyPostException {
        params.put("carbon_offset", withCarbonOffset);
        Shipment response = Shipment.request(EasyPostResource.RequestMethod.POST, String.format("%s/rerate", Shipment.instanceURL(Shipment.class, this.getId())), params, Shipment.class, apiKey);
        this.merge(this, response);
        return this;
    }

    @Deprecated
    public List<Smartrate> getSmartrates(Map<String, Object> params) throws EasyPostException {
        return this.smartrates(params);
    }

    public List<Smartrate> smartrates(Map<String, Object> params) throws EasyPostException {
        return this.smartrates(params, null);
    }

    @Deprecated
    public List<Smartrate> getSmartrates(Map<String, Object> params, String apiKey) throws EasyPostException {
        return this.smartrates(params, apiKey);
    }

    public List<Smartrate> smartrates(Map<String, Object> params, String apiKey) throws EasyPostException {
        SmartrateCollection smartrateCollection = Shipment.request(EasyPostResource.RequestMethod.GET, String.format("%s/smartrate", Shipment.instanceURL(Shipment.class, this.getId())), params, SmartrateCollection.class, apiKey);
        return smartrateCollection.getSmartrates();
    }

    @Deprecated
    public List<Smartrate> getSmartrates(String apiKey) throws EasyPostException {
        return this.smartrates(apiKey);
    }

    public List<Smartrate> smartrates(String apiKey) throws EasyPostException {
        return this.smartrates(null, apiKey);
    }

    public Shipment buy(Map<String, Object> params) throws EasyPostException {
        return this.buy(params, false, null);
    }

    public Shipment buy(Rate rate) throws EasyPostException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("rate", rate);
        return this.buy(params, false, null);
    }

    public Shipment buy(Rate rate, boolean withCarbonOffset) throws EasyPostException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("rate", rate);
        return this.buy(params, withCarbonOffset, null, null);
    }

    public Shipment buy(Rate rate, String endShipperId) throws EasyPostException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("rate", rate);
        return this.buy(params, false, endShipperId, null);
    }

    public Shipment buy(Map<String, Object> params, String apiKey) throws EasyPostException {
        return this.buy(params, false, null, apiKey);
    }

    public Shipment buy(Map<String, Object> params, boolean withCarbonOffset) throws EasyPostException {
        return this.buy(params, withCarbonOffset, null);
    }

    public Shipment buy(Rate rate, boolean withCarbonOffset, String endShipperId, String apiKey) throws EasyPostException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("rate", rate);
        return this.buy(params, withCarbonOffset, endShipperId, apiKey);
    }

    public Shipment buy(Map<String, Object> params, boolean withCarbonOffset, String apiKey) throws EasyPostException {
        return this.buy(params, withCarbonOffset, null, apiKey);
    }

    public Shipment buy(Map<String, Object> params, String endShipperId, String apiKey) throws EasyPostException {
        return this.buy(params, false, endShipperId, apiKey);
    }

    public Shipment buy(Map<String, Object> params, boolean withCarbonOffset, String endShipperId, String apiKey) throws EasyPostException {
        params.put("carbon_offset", withCarbonOffset);
        if (endShipperId != null && !endShipperId.isEmpty()) {
            params.put("end_shipper_id", endShipperId);
        }
        Shipment response = Shipment.request(EasyPostResource.RequestMethod.POST, String.format("%s/buy", Shipment.instanceURL(Shipment.class, this.getId())), params, Shipment.class, apiKey);
        this.merge(this, response);
        return this;
    }

    public Shipment refund() throws EasyPostException {
        return this.refund(null, null);
    }

    public Shipment refund(Map<String, Object> params, String apiKey) throws EasyPostException {
        return Shipment.request(EasyPostResource.RequestMethod.GET, String.format("%s/refund", Shipment.instanceURL(Shipment.class, this.getId())), params, Shipment.class, apiKey);
    }

    public Shipment refund(Map<String, Object> params) throws EasyPostException {
        return this.refund(params, null);
    }

    public Shipment refund(String apiKey) throws EasyPostException {
        return this.refund(null, apiKey);
    }

    public Shipment label() throws EasyPostException {
        return this.label(null, null);
    }

    public Shipment label(Map<String, Object> params, String apiKey) throws EasyPostException {
        Shipment response = Shipment.request(EasyPostResource.RequestMethod.GET, String.format("%s/label", Shipment.instanceURL(Shipment.class, this.getId())), params, Shipment.class, apiKey);
        this.merge(this, response);
        return this;
    }

    public Shipment label(Map<String, Object> params) throws EasyPostException {
        return this.label(params, null);
    }

    public Shipment label(String apiKey) throws EasyPostException {
        return this.label(null, apiKey);
    }

    public Shipment insure() throws EasyPostException {
        return this.insure(null, null);
    }

    public Shipment insure(Map<String, Object> params, String apiKey) throws EasyPostException {
        return Shipment.request(EasyPostResource.RequestMethod.POST, String.format("%s/insure", Shipment.instanceURL(Shipment.class, this.getId())), params, Shipment.class, apiKey);
    }

    public Shipment insure(Map<String, Object> params) throws EasyPostException {
        return this.insure(params, null);
    }

    public Shipment insure(String apiKey) throws EasyPostException {
        return this.insure(null, apiKey);
    }

    @Deprecated
    public Smartrate lowestSmartRate(int deliveryDay, String deliveryAccuracy) throws EasyPostException {
        return this.lowestSmartRate(deliveryDay, SmartrateAccuracy.getByKeyName(deliveryAccuracy));
    }

    public Smartrate lowestSmartRate(int deliveryDay, SmartrateAccuracy deliveryAccuracy) throws EasyPostException {
        List<Smartrate> smartrates = this.smartrates();
        Smartrate lowestSmartrate = Shipment.findLowestSmartrate(smartrates, deliveryDay, deliveryAccuracy);
        return lowestSmartrate;
    }

    @Deprecated
    public List<Smartrate> getSmartrates() throws EasyPostException {
        return this.smartrates();
    }

    public List<Smartrate> smartrates() throws EasyPostException {
        return this.smartrates(null, null);
    }

    @Deprecated
    public static Smartrate getLowestSmartRate(List<Smartrate> smartrates, int deliveryDay, String deliveryAccuracy) throws EasyPostException {
        return Shipment.findLowestSmartrate(smartrates, deliveryDay, SmartrateAccuracy.getByKeyName(deliveryAccuracy));
    }

    public static Smartrate findLowestSmartrate(List<Smartrate> smartrates, int deliveryDay, SmartrateAccuracy deliveryAccuracy) throws EasyPostException {
        Smartrate lowestSmartrate = null;
        for (Smartrate rate : smartrates) {
            int smartrateDeliveryDay = rate.getTimeInTransit().getBySmartrateAccuracy(deliveryAccuracy);
            if (smartrateDeliveryDay > deliveryDay || lowestSmartrate != null && !(rate.getRate().floatValue() < lowestSmartrate.getRate().floatValue())) continue;
            lowestSmartrate = rate;
        }
        if (lowestSmartrate == null) {
            throw new EasyPostException("No rates found.");
        }
        return lowestSmartrate;
    }

    public Rate lowestRate() throws EasyPostException {
        return this.lowestRate(null, null);
    }

    public Rate lowestRate(List<String> carriers, List<String> services) throws EasyPostException {
        return Utilities.getLowestObjectRate(this.rates, carriers, services);
    }

    public Rate lowestRate(List<String> carriers) throws EasyPostException {
        return this.lowestRate(carriers, null);
    }

    public void generateForm(String formType) throws EasyPostException {
        this.generateForm(formType, null, null);
    }

    public void generateForm(String formType, String apiKey) throws EasyPostException {
        this.generateForm(formType, null, apiKey);
    }

    public void generateForm(String formType, Map<String, Object> formOptions) throws EasyPostException {
        this.generateForm(formType, formOptions, null);
    }

    public void generateForm(String formType, Map<String, Object> formOptions, String apiKey) throws EasyPostException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        params.put("type", formType);
        params.putAll(formOptions);
        wrappedParams.put("form", params);
        Shipment response = Shipment.request(EasyPostResource.RequestMethod.POST, String.format("%s/forms", Shipment.instanceURL(Shipment.class, this.getId())), wrappedParams, Shipment.class, apiKey);
        this.merge(this, response);
    }
}

