/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.model;

import com.easypost.exception.EasyPostException;
import com.easypost.model.Address;
import com.easypost.model.CarrierAccount;
import com.easypost.model.PickupRate;
import com.easypost.model.ShipmentMessage;
import com.easypost.net.EasyPostResource;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Pickup
extends EasyPostResource {
    private String id;
    private String mode;
    private String status;
    private String reference;
    private Date minDatetime;
    private Date maxDatetime;
    private Boolean isAccountAddress;
    private String instructions;
    private List<ShipmentMessage> messages;
    private String confirmation;
    private Address address;
    private List<CarrierAccount> carrierAccounts;
    private List<PickupRate> pickupRates;

    public static Pickup create(Map<String, Object> params) throws EasyPostException {
        return Pickup.create(params, null);
    }

    public static Pickup create(Map<String, Object> params, String apiKey) throws EasyPostException {
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        wrappedParams.put("pickup", params);
        return Pickup.request(EasyPostResource.RequestMethod.POST, Pickup.classURL(Pickup.class), wrappedParams, Pickup.class, apiKey);
    }

    public static Pickup retrieve(String id) throws EasyPostException {
        return Pickup.retrieve(id, null);
    }

    public static Pickup retrieve(String id, String apiKey) throws EasyPostException {
        return Pickup.request(EasyPostResource.RequestMethod.GET, Pickup.instanceURL(Pickup.class, id), null, Pickup.class, apiKey);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public Date getMinDatetime() {
        return this.minDatetime;
    }

    public void setMinDatetime(Date minDatetime) {
        this.minDatetime = minDatetime;
    }

    public Date getMaxDatetime() {
        return this.maxDatetime;
    }

    public void setMaxDatetime(Date maxDatetime) {
        this.maxDatetime = maxDatetime;
    }

    public Boolean getIsAccountAddress() {
        return this.isAccountAddress;
    }

    public void setIsAccountAddress(Boolean isAccountAddress) {
        this.isAccountAddress = isAccountAddress;
    }

    public String getInstructions() {
        return this.instructions;
    }

    public void setInstructions(String instructions) {
        this.instructions = instructions;
    }

    public List<ShipmentMessage> getMessages() {
        return this.messages;
    }

    public void setMessages(List<ShipmentMessage> messages) {
        this.messages = messages;
    }

    public String getConfirmation() {
        return this.confirmation;
    }

    public void setConfirmation(String confirmation) {
        this.confirmation = confirmation;
    }

    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public List<CarrierAccount> getCarrierAccounts() {
        return this.carrierAccounts;
    }

    public void setCarrierAccounts(List<CarrierAccount> carrierAccounts) {
        this.carrierAccounts = carrierAccounts;
    }

    public List<PickupRate> getPickupRates() {
        return this.pickupRates;
    }

    public void setPickupRates(List<PickupRate> pickupRates) {
        this.pickupRates = pickupRates;
    }

    public Pickup refresh() throws EasyPostException {
        return this.refresh(null, null);
    }

    public Pickup refresh(Map<String, Object> params) throws EasyPostException {
        return this.refresh(params, null);
    }

    public Pickup refresh(String apiKey) throws EasyPostException {
        return this.refresh(null, apiKey);
    }

    public Pickup refresh(Map<String, Object> params, String apiKey) throws EasyPostException {
        return Pickup.request(EasyPostResource.RequestMethod.GET, String.format("%s", Pickup.instanceURL(Pickup.class, this.getId())), params, Pickup.class, apiKey);
    }

    public Pickup buy() throws EasyPostException {
        return this.buy(null, null);
    }

    public Pickup buy(Map<String, Object> params) throws EasyPostException {
        return this.buy(params, null);
    }

    public Pickup buy(String apiKey) throws EasyPostException {
        return this.buy(null, apiKey);
    }

    public Pickup buy(PickupRate pickupRate) throws EasyPostException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("rate", pickupRate);
        return this.buy(params, null);
    }

    public Pickup buy(Map<String, Object> params, String apiKey) throws EasyPostException {
        Pickup response = Pickup.request(EasyPostResource.RequestMethod.POST, String.format("%s/buy", Pickup.instanceURL(Pickup.class, this.getId())), params, Pickup.class, apiKey);
        this.merge(this, response);
        return this;
    }

    public Pickup cancel() throws EasyPostException {
        return this.cancel(null, null);
    }

    public Pickup cancel(Map<String, Object> params) throws EasyPostException {
        return this.cancel(params, null);
    }

    public Pickup cancel(String apiKey) throws EasyPostException {
        return this.cancel(null, apiKey);
    }

    public Pickup cancel(Map<String, Object> params, String apiKey) throws EasyPostException {
        return Pickup.request(EasyPostResource.RequestMethod.POST, String.format("%s/cancel", Pickup.instanceURL(Pickup.class, this.getId())), params, Pickup.class, apiKey);
    }
}

