/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.model;

import com.easypost.exception.EasyPostException;
import com.easypost.model.AddressCollection;
import com.easypost.model.AddressVerifications;
import com.easypost.model.AddressVerifyResponse;
import com.easypost.model.BaseAddress;
import com.easypost.net.EasyPostResource;
import java.util.HashMap;
import java.util.Map;

public final class Address
extends BaseAddress {
    private String mode;
    private String message;
    private String carrierFacility;
    private String federalTaxId;
    private Boolean residential;
    private AddressVerifications verifications;

    public static Address create(Map<String, Object> params) throws EasyPostException {
        return Address.create(params, null);
    }

    public static Address create(Map<String, Object> params, String apiKey) throws EasyPostException {
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        if (params.containsKey("verify")) {
            wrappedParams.put("verify", params.remove("verify"));
        }
        if (params.containsKey("verify_strict")) {
            wrappedParams.put("verify_strict", params.remove("verify_strict"));
        }
        wrappedParams.put("address", params);
        return Address.request(EasyPostResource.RequestMethod.POST, Address.classURL(Address.class), wrappedParams, Address.class, apiKey);
    }

    public static Address retrieve(String id) throws EasyPostException {
        return Address.retrieve(id, null);
    }

    public static Address retrieve(String id, String apiKey) throws EasyPostException {
        return Address.request(EasyPostResource.RequestMethod.GET, Address.instanceURL(Address.class, id), null, Address.class, apiKey);
    }

    public static AddressCollection all(Map<String, Object> params) throws EasyPostException {
        return Address.all(params, null);
    }

    public static AddressCollection all(Map<String, Object> params, String apiKey) throws EasyPostException {
        return Address.request(EasyPostResource.RequestMethod.GET, Address.classURL(Address.class), params, AddressCollection.class, apiKey);
    }

    public static Address createAndVerify(Map<String, Object> params) throws EasyPostException {
        return Address.createAndVerify(params, null);
    }

    public static Address createAndVerify(Map<String, Object> params, String apiKey) throws EasyPostException {
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        wrappedParams.put("address", params);
        AddressVerifyResponse response = Address.request(EasyPostResource.RequestMethod.POST, String.format("%s/create_and_verify", Address.classURL(Address.class)), wrappedParams, AddressVerifyResponse.class, apiKey);
        return response.getAddress();
    }

    public static Address createAndVerifyWithCarrier(Map<String, Object> params, String carrier) throws EasyPostException {
        return Address.createAndVerifyWithCarrier(params, carrier, null);
    }

    public static Address createAndVerifyWithCarrier(Map<String, Object> params, String carrier, String apiKey) throws EasyPostException {
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        wrappedParams.put("address", params);
        wrappedParams.put("carrier", carrier);
        AddressVerifyResponse response = Address.request(EasyPostResource.RequestMethod.POST, String.format("%s/create_and_verify", Address.classURL(Address.class)), wrappedParams, AddressVerifyResponse.class, apiKey);
        if (response.getMessage() != null) {
            response.getAddress().setMessage(response.getMessage());
        }
        return response.getAddress();
    }

    @Override
    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getCarrierFacility() {
        return this.carrierFacility;
    }

    public void setCarrierFacility(String carrierFacility) {
        this.carrierFacility = carrierFacility;
    }

    public String getFederalTaxId() {
        return this.federalTaxId;
    }

    public void setFederalTaxId(String federalTaxId) {
        this.federalTaxId = federalTaxId;
    }

    public Boolean getResidential() {
        return this.residential;
    }

    public void setResidential(Boolean residential) {
        this.residential = residential;
    }

    public AddressVerifications getVerifications() {
        return this.verifications;
    }

    public void setVerifications(AddressVerifications verifications) {
        this.verifications = verifications;
    }

    public Address verify() throws EasyPostException {
        return this.verify(null);
    }

    public Address verify(String apiKey) throws EasyPostException {
        AddressVerifyResponse response = Address.request(EasyPostResource.RequestMethod.GET, String.format("%s/verify", Address.instanceURL(Address.class, this.getId())), null, AddressVerifyResponse.class, apiKey);
        if (response.getMessage() != null) {
            response.getAddress().setMessage(response.getMessage());
        }
        return response.getAddress();
    }

    public Address verifyWithCarrier(String carrier) throws EasyPostException {
        return this.verifyWithCarrier(carrier, null);
    }

    public Address verifyWithCarrier(String carrier, String apiKey) throws EasyPostException {
        HashMap<String, String> wrappedParams = new HashMap<String, String>();
        wrappedParams.put("carrier", carrier);
        AddressVerifyResponse response = Address.request(EasyPostResource.RequestMethod.GET, String.format("%s/verify", Address.instanceURL(Address.class, this.getId())), null, AddressVerifyResponse.class, apiKey);
        if (response.getMessage() != null) {
            response.getAddress().setMessage(response.getMessage());
        }
        return response.getAddress();
    }
}

