/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.net;

import com.easypost.EasyPost;
import com.easypost.exception.EasyPostException;
import com.easypost.model.Event;
import com.easypost.model.EventDeserializer;
import com.easypost.model.Fee;
import com.easypost.model.Rate;
import com.easypost.model.RateDeserializer;
import com.easypost.model.Shipment;
import com.easypost.model.SmartrateCollection;
import com.easypost.model.SmartrateCollectionDeserializer;
import com.easypost.model.TrackingDetail;
import com.easypost.net.EasyPostResponse;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.URLStreamHandler;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import javax.net.ssl.HttpsURLConnection;

public abstract class EasyPostResource {
    public static final String EASYPOST_SUPPORT_EMAIL = "support@easypost.com";
    public static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapter(Event.class, (Object)new EventDeserializer()).registerTypeAdapter(Rate.class, (Object)new RateDeserializer()).registerTypeAdapter(SmartrateCollection.class, (Object)new SmartrateCollectionDeserializer()).create();
    public static final Gson PRETTY_PRINT_GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapter(Event.class, (Object)new EventDeserializer()).create();
    public static final String CHARSET = "UTF-8";
    public static final ArrayList<String> GLOBAL_FIELD_ACCESSORS = new ArrayList<String>(Arrays.asList("getCreatedAt", "getUpdatedAt", "getFees"));
    public static final int DEFAULT_CONNECT_TIMEOUT_MILLISECONDS = 30000;
    public static final int DEFAULT_READ_TIMEOUT_MILLISECONDS = 60000;
    public static final double DEFAULT_APP_ENGINE_TIMEOUT_SECONDS = 20.0;
    private static final String DNS_CACHE_TTL_PROPERTY_NAME = "networkaddress.cache.ttl";
    private static final String CUSTOM_URL_STREAM_HANDLER_PROPERTY_NAME = "com.easypost.net.customURLStreamHandler";
    private static int connectTimeoutMilliseconds = 30000;
    private static int readTimeoutMilliseconds = 60000;
    private static double appEngineTimeoutSeconds = 20.0;
    private Date createdAt;
    private Date updatedAt;
    private ArrayList<Fee> fees;

    private static String className(Class<?> clazz) {
        return clazz.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase().replace("$", "");
    }

    protected static String singleClassURL(Class<?> clazz) {
        return String.format("%s/%s", EasyPost.API_BASE, EasyPostResource.className(clazz));
    }

    protected static String classURL(Class<?> clazz) {
        String singleURL = EasyPostResource.singleClassURL(clazz);
        if (singleURL.charAt(singleURL.length() - 1) == 's' || singleURL.charAt(singleURL.length() - 1) == 'h') {
            return String.format("%ses", EasyPostResource.singleClassURL(clazz));
        }
        return String.format("%ss", EasyPostResource.singleClassURL(clazz));
    }

    protected static String instanceURL(Class<?> clazz, String id) {
        return String.format("%s/%s", EasyPostResource.classURL(clazz), id);
    }

    private static String urlEncodePair(String key, String value) throws UnsupportedEncodingException {
        return String.format("%s=%s", URLEncoder.encode(key, CHARSET), URLEncoder.encode(value, CHARSET));
    }

    static Map<String, String> getHeaders(String apiKey) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept-Charset", CHARSET);
        headers.put("User-Agent", String.format("EasyPost/v2 JavaClient/%s Java/%s", "5.4.0", System.getProperty("java.version")));
        if (apiKey == null) {
            apiKey = EasyPost.apiKey;
        }
        headers.put("Authorization", String.format("Bearer %s", apiKey));
        String[] propertyNames = new String[]{"os.name", "os.version", "os.arch", "java.version", "java.vendor", "java.vm.version", "java.vm.vendor"};
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        for (String propertyName : propertyNames) {
            propertyMap.put(propertyName, System.getProperty(propertyName));
        }
        propertyMap.put("lang", "Java");
        propertyMap.put("publisher", "EasyPost");
        headers.put("X-Client-User-Agent", GSON.toJson(propertyMap));
        return headers;
    }

    private static HttpsURLConnection createEasyPostConnection(String url, String apiKey, String method) throws IOException {
        Object conn = null;
        String customURLStreamHandlerClassName = System.getProperty(CUSTOM_URL_STREAM_HANDLER_PROPERTY_NAME, null);
        if (customURLStreamHandlerClassName != null) {
            try {
                Class<?> clazz = Class.forName(customURLStreamHandlerClassName);
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                URLStreamHandler customHandler = (URLStreamHandler)constructor.newInstance(new Object[0]);
                URL urlObj = new URL(null, url, customHandler);
                conn = (HttpsURLConnection)urlObj.openConnection();
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
            catch (SecurityException e) {
                throw new IOException(e);
            }
            catch (NoSuchMethodException e) {
                throw new IOException(e);
            }
            catch (IllegalArgumentException e) {
                throw new IOException(e);
            }
            catch (InstantiationException e) {
                throw new IOException(e);
            }
            catch (IllegalAccessException e) {
                throw new IOException(e);
            }
            catch (InvocationTargetException e) {
                throw new IOException(e);
            }
        } else if (EasyPost._vcr != null) {
            try {
                conn = EasyPost._vcr.getHttpUrlConnection(url).openConnectionSecure();
            }
            catch (Exception vcrException) {
                throw new IOException(vcrException);
            }
        } else {
            URL urlObj = new URL(null, url);
            conn = (HttpsURLConnection)urlObj.openConnection();
        }
        ((URLConnection)conn).setConnectTimeout(EasyPostResource.getConnectTimeoutMilliseconds());
        ((HttpURLConnection)conn).setRequestMethod(method);
        int readTimeout = EasyPost.readTimeout != 0 ? EasyPost.readTimeout : EasyPostResource.getReadTimeoutMilliseconds();
        ((URLConnection)conn).setReadTimeout(readTimeout);
        ((URLConnection)conn).setUseCaches(false);
        for (Map.Entry<String, String> header : EasyPostResource.getHeaders(apiKey).entrySet()) {
            ((URLConnection)conn).setRequestProperty(header.getKey(), header.getValue());
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HttpsURLConnection writeBody(HttpsURLConnection conn, JsonObject body) throws IOException {
        if (body != null) {
            conn.setDoOutput(true);
            conn.setRequestProperty("Content-Type", "application/json");
            try (OutputStream output = null;){
                output = conn.getOutputStream();
                String jsonString = body.toString();
                output.write(jsonString.getBytes(CHARSET));
            }
        }
        return conn;
    }

    private static HttpsURLConnection createGetConnection(String url, String query, String apiKey) throws IOException {
        String getURL = url;
        if (query != null) {
            getURL = String.format("%s?%s", url, query);
        }
        HttpsURLConnection conn = EasyPostResource.createEasyPostConnection(getURL, apiKey, "GET");
        return conn;
    }

    private static HttpsURLConnection createPostConnection(String url, JsonObject body, String apiKey) throws IOException {
        HttpsURLConnection conn = EasyPostResource.createEasyPostConnection(url, apiKey, "POST");
        conn = EasyPostResource.writeBody(conn, body);
        return conn;
    }

    private static HttpsURLConnection createDeleteConnection(String url, String query, String apiKey) throws IOException {
        String deleteUrl = url;
        if (query != null) {
            deleteUrl = String.format("%s?%s", url, query);
        }
        HttpsURLConnection conn = EasyPostResource.createEasyPostConnection(deleteUrl, apiKey, "DELETE");
        return conn;
    }

    private static HttpsURLConnection createPutConnection(String url, JsonObject body, String apiKey) throws IOException {
        HttpsURLConnection conn = EasyPostResource.createEasyPostConnection(url, apiKey, "PUT");
        conn = EasyPostResource.writeBody(conn, body);
        return conn;
    }

    private static JsonObject createBody(Map<String, Object> params) {
        Gson gson = new Gson();
        return gson.toJsonTree(params).getAsJsonObject();
    }

    private static String createQuery(Map<String, Object> params) throws UnsupportedEncodingException {
        Map<String, String> flatParams = EasyPostResource.flattenParams(params);
        StringBuilder queryStringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : flatParams.entrySet()) {
            queryStringBuilder.append("&");
            queryStringBuilder.append(EasyPostResource.urlEncodePair(entry.getKey(), entry.getValue()));
        }
        if (queryStringBuilder.length() > 0) {
            queryStringBuilder.deleteCharAt(0);
        }
        return queryStringBuilder.toString();
    }

    private static Map<String, String> flattenParams(Map<String, Object> params) {
        if (params == null) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> flatParams = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            HashMap<String, Object> flatNestedMap;
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                flatNestedMap = new HashMap<String, Object>();
                Map nestedMap = (Map)value;
                for (Map.Entry nestedEntry : nestedMap.entrySet()) {
                    flatNestedMap.put(String.format("%s[%s]", key, nestedEntry.getKey()), nestedEntry.getValue());
                }
                flatParams.putAll(EasyPostResource.flattenParams(flatNestedMap));
                continue;
            }
            if (value instanceof List) {
                flatNestedMap = new HashMap();
                List nestedList = (List)value;
                for (int i = 0; i < nestedList.size(); ++i) {
                    flatNestedMap.put(String.format("%s[%s]", key, i), nestedList.get(i));
                    flatParams.putAll(EasyPostResource.flattenParams(flatNestedMap));
                }
                continue;
            }
            if (value instanceof EasyPostResource) {
                flatParams.put(String.format("%s[%s]", key, "id"), value.toString());
                continue;
            }
            if (value == null) continue;
            flatParams.put(key, value.toString());
        }
        return flatParams;
    }

    private static String getResponseBody(InputStream responseStream) throws IOException {
        String rBody = new Scanner(responseStream, CHARSET).useDelimiter("\\A").next();
        responseStream.close();
        return rBody;
    }

    private static EasyPostResponse makeURLConnectionRequest(RequestMethod method, String url, String query, JsonObject body, String apiKey) throws EasyPostException {
        HttpURLConnection conn = null;
        try {
            switch (method) {
                case GET: {
                    conn = EasyPostResource.createGetConnection(url, query, apiKey);
                    break;
                }
                case POST: {
                    conn = EasyPostResource.createPostConnection(url, body, apiKey);
                    break;
                }
                case PUT: {
                    conn = EasyPostResource.createPutConnection(url, body, apiKey);
                    break;
                }
                case DELETE: {
                    conn = EasyPostResource.createDeleteConnection(url, query, apiKey);
                    break;
                }
                default: {
                    throw new EasyPostException(String.format("Unrecognized HTTP method %s. Please contact EasyPost at %s.", new Object[]{method, EASYPOST_SUPPORT_EMAIL}));
                }
            }
            conn.connect();
            int rCode = conn.getResponseCode();
            String rBody = null;
            rBody = rCode == 204 ? "" : (rCode >= 200 && rCode < 300 ? EasyPostResource.getResponseBody(conn.getInputStream()) : EasyPostResource.getResponseBody(conn.getErrorStream()));
            EasyPostResponse easyPostResponse = new EasyPostResponse(rCode, rBody);
            return easyPostResponse;
        }
        catch (IOException e) {
            throw new EasyPostException(String.format("Could not connect to EasyPost (%s). Please check your internet connection and try again. If this problem persists,please contact us at %s.", EasyPost.API_BASE, EASYPOST_SUPPORT_EMAIL), e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    protected static <T> T request(RequestMethod method, String url, Map<String, Object> params, Class<T> clazz, String apiKey) throws EasyPostException {
        return EasyPostResource.request(method, url, params, clazz, apiKey, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <T> T request(RequestMethod method, String url, Map<String, Object> params, Class<T> clazz, String apiKey, boolean apiKeyRequired) throws EasyPostException {
        String originalDNSCacheTTL = null;
        boolean allowedToSetTTL = true;
        try {
            originalDNSCacheTTL = Security.getProperty(DNS_CACHE_TTL_PROPERTY_NAME);
            Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, "0");
        }
        catch (SecurityException se) {
            allowedToSetTTL = false;
        }
        try {
            T t = EasyPostResource._request(method, url, params, clazz, apiKey, apiKeyRequired);
            return t;
        }
        finally {
            if (allowedToSetTTL) {
                if (originalDNSCacheTTL == null) {
                    Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, "-1");
                } else {
                    Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, originalDNSCacheTTL);
                }
            }
        }
    }

    protected static <T> T _request(RequestMethod method, String url, Map<String, Object> params, Class<T> clazz, String apiKey, boolean apiKeyRequired) throws EasyPostException {
        EasyPostResponse response;
        if (!(EasyPost.apiKey != null && EasyPost.apiKey.length() != 0 || apiKey != null && apiKey.length() != 0 || !apiKeyRequired)) {
            throw new EasyPostException(String.format("No API key provided. (set your API key using 'EasyPost.apiKey = {KEY}'. Your API key can be found in your EasyPost dashboard, or you can email us at %s for assistance.", EASYPOST_SUPPORT_EMAIL));
        }
        if (apiKey == null) {
            apiKey = EasyPost.apiKey;
        }
        String query = null;
        JsonObject body = null;
        if (params != null) {
            switch (method) {
                case GET: 
                case DELETE: {
                    try {
                        query = EasyPostResource.createQuery(params);
                        break;
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new EasyPostException(String.format("Unable to encode parameters to %s. Please email %s for assistance.", CHARSET, EASYPOST_SUPPORT_EMAIL), e);
                    }
                }
                case POST: 
                case PUT: {
                    try {
                        body = EasyPostResource.createBody(params);
                        break;
                    }
                    catch (Exception e) {
                        throw new EasyPostException(String.format("Unable to create JSON body from parameters. Please email %s for assistance.", EASYPOST_SUPPORT_EMAIL), e);
                    }
                }
            }
        }
        try {
            response = EasyPostResource.makeURLConnectionRequest(method, url, query, body, apiKey);
        }
        catch (ClassCastException ce) {
            String appEngineEnv = System.getProperty("com.google.appengine.runtime.environment", null);
            if (appEngineEnv != null) {
                response = EasyPostResource.makeAppEngineRequest(method, url, query, body, apiKey);
            }
            throw ce;
        }
        int rCode = response.getResponseCode();
        String rBody = response.getResponseBody();
        if (rCode < 200 || rCode >= 300) {
            EasyPostResource.handleAPIError(rBody, rCode);
        }
        return (T)GSON.fromJson(rBody, clazz);
    }

    private static void handleAPIError(String rBody, int rCode) throws EasyPostException {
        try {
            Error error = (Error)GSON.fromJson(rBody, Error.class);
            if (error.getError().length() > 0) {
                throw new EasyPostException(error.getError());
            }
            throw new EasyPostException(error.getMessage(), error.getParam(), null);
        }
        catch (Exception e) {
            throw new EasyPostException(String.format("An error occurred. Response code: %s Response body: %s", rCode, rBody));
        }
    }

    private static EasyPostResponse makeAppEngineRequest(RequestMethod method, String url, String query, JsonObject body, String apiKey) throws EasyPostException {
        String unknownErrorMessage = String.format("Sorry, an unknown error occurred while trying to use the Google App Engine runtime.Please email %s for assistance.", EASYPOST_SUPPORT_EMAIL);
        try {
            if ((method == RequestMethod.GET || method == RequestMethod.DELETE) && query != null) {
                url = String.format("%s?%s", url, query);
            }
            URL fetchURL = new URL(url);
            Class<?> requestMethodClass = Class.forName("com.google.appengine.api.urlfetch.HTTPMethod");
            Object httpMethod = requestMethodClass.getDeclaredField(method.name()).get(null);
            Class<?> fetchOptionsBuilderClass = Class.forName("com.google.appengine.api.urlfetch.FetchOptions$Builder");
            Object fetchOptions = null;
            try {
                fetchOptions = fetchOptionsBuilderClass.getDeclaredMethod("validateCertificate", new Class[0]).invoke(null, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                System.err.printf("Warning: this App Engine SDK version does not allow verification of SSL certificates;this exposes you to a MITM attack. Please upgrade your App Engine SDK to >=1.5.0. If you have questions, email %s.%n", EASYPOST_SUPPORT_EMAIL);
                fetchOptions = fetchOptionsBuilderClass.getDeclaredMethod("withDefaults", new Class[0]).invoke(null, new Object[0]);
            }
            Class<?> fetchOptionsClass = Class.forName("com.google.appengine.api.urlfetch.FetchOptions");
            fetchOptionsClass.getDeclaredMethod("setDeadline", Double.class).invoke(fetchOptions, EasyPostResource.getAppEngineTimeoutSeconds());
            Class<?> requestClass = Class.forName("com.google.appengine.api.urlfetch.HTTPRequest");
            Object request = requestClass.getDeclaredConstructor(URL.class, requestMethodClass, fetchOptionsClass).newInstance(fetchURL, httpMethod, fetchOptions);
            if ((method == RequestMethod.POST || method == RequestMethod.PUT) && body != null) {
                String bodyString = body.toString();
                requestClass.getDeclaredMethod("setPayload", byte[].class).invoke(request, new Object[]{bodyString.getBytes()});
            }
            for (Map.Entry entry : EasyPostResource.getHeaders(apiKey).entrySet()) {
                Class<?> httpHeaderClass = Class.forName("com.google.appengine.api.urlfetch.HTTPHeader");
                Object reqHeader = httpHeaderClass.getDeclaredConstructor(String.class, String.class).newInstance(entry.getKey(), entry.getValue());
                requestClass.getDeclaredMethod("setHeader", httpHeaderClass).invoke(request, reqHeader);
            }
            Class<?> urlFetchFactoryClass = Class.forName("com.google.appengine.api.urlfetch.URLFetchServiceFactory");
            Object object = urlFetchFactoryClass.getDeclaredMethod("getURLFetchService", new Class[0]).invoke(null, new Object[0]);
            Method fetchMethod = object.getClass().getDeclaredMethod("fetch", requestClass);
            fetchMethod.setAccessible(true);
            Object response = fetchMethod.invoke(object, request);
            int responseCode = (Integer)response.getClass().getDeclaredMethod("getResponseCode", new Class[0]).invoke(response, new Object[0]);
            String responseBody = new String((byte[])response.getClass().getDeclaredMethod("getContent", new Class[0]).invoke(response, new Object[0]), CHARSET);
            return new EasyPostResponse(responseCode, responseBody);
        }
        catch (InvocationTargetException e) {
            throw new EasyPostException(unknownErrorMessage, e);
        }
        catch (MalformedURLException e) {
            throw new EasyPostException(unknownErrorMessage, e);
        }
        catch (NoSuchFieldException e) {
            throw new EasyPostException(unknownErrorMessage, e);
        }
        catch (SecurityException e) {
            throw new EasyPostException(unknownErrorMessage, e);
        }
        catch (NoSuchMethodException e) {
            throw new EasyPostException(unknownErrorMessage, e);
        }
        catch (ClassNotFoundException e) {
            throw new EasyPostException(unknownErrorMessage, e);
        }
        catch (IllegalArgumentException e) {
            throw new EasyPostException(unknownErrorMessage, e);
        }
        catch (IllegalAccessException e) {
            throw new EasyPostException(unknownErrorMessage, e);
        }
        catch (InstantiationException e) {
            throw new EasyPostException(unknownErrorMessage, e);
        }
        catch (UnsupportedEncodingException e) {
            throw new EasyPostException(unknownErrorMessage, e);
        }
    }

    public static int getConnectTimeoutMilliseconds() {
        return connectTimeoutMilliseconds;
    }

    public static void setConnectTimeoutMilliseconds(int milliseconds) {
        connectTimeoutMilliseconds = milliseconds;
    }

    public static int getReadTimeoutMilliseconds() {
        return readTimeoutMilliseconds;
    }

    public static void setReadTimeoutMilliseconds(int milliseconds) {
        readTimeoutMilliseconds = milliseconds;
    }

    public static double getAppEngineTimeoutSeconds() {
        return appEngineTimeoutSeconds;
    }

    public static void setAppEngineTimeoutSeconds(double seconds) {
        appEngineTimeoutSeconds = seconds;
    }

    public String toString() {
        return (String)this.getIdString();
    }

    public String prettyPrint() {
        return String.format("<%s@%s id=%s> JSON: %s", this.getClass().getName(), System.identityHashCode(this), this.getIdString(), PRETTY_PRINT_GSON.toJson((Object)this));
    }

    private Object getIdString() {
        try {
            Field idField = this.getClass().getDeclaredField("id");
            return idField.get(this);
        }
        catch (SecurityException e) {
            return "";
        }
        catch (NoSuchFieldException e) {
            return "";
        }
        catch (IllegalArgumentException e) {
            return "";
        }
        catch (IllegalAccessException e) {
            return "";
        }
    }

    private static List<Method> getAllMethods(Class<?> type) {
        return Arrays.asList(type.getMethods());
    }

    private static List<Method> getAllNonStaticMethods(Class<?> type) {
        List<Method> allMethods = EasyPostResource.getAllMethods(type);
        ArrayList<Method> nonStaticMethods = new ArrayList<Method>();
        for (Method method : allMethods) {
            if (Modifier.isStatic(method.getModifiers())) continue;
            nonStaticMethods.add(method);
        }
        return nonStaticMethods;
    }

    private static List<Method> getAllStaticMethods(Class<?> type) {
        List<Method> allMethods = EasyPostResource.getAllMethods(type);
        ArrayList<Method> staticMethods = new ArrayList<Method>();
        for (Method method : allMethods) {
            if (!Modifier.isStatic(method.getModifiers())) continue;
            staticMethods.add(method);
        }
        return staticMethods;
    }

    public void merge(EasyPostResource obj, EasyPostResource update) {
        if (!obj.getClass().isAssignableFrom(update.getClass())) {
            return;
        }
        List<Method> methods = EasyPostResource.getAllNonStaticMethods(obj.getClass());
        for (Method fromMethod : methods) {
            if (!fromMethod.getName().startsWith("get") && !GLOBAL_FIELD_ACCESSORS.contains(fromMethod.getName())) continue;
            String fromName = fromMethod.getName();
            String toName = fromName.replace("get", "set");
            try {
                Object value = fromMethod.invoke((Object)update, (Object[])null);
                if (value == null) continue;
                Method toMethod = obj.getClass().getMethod(toName, fromMethod.getReturnType());
                toMethod.invoke((Object)obj, value);
            }
            catch (Exception exception) {}
        }
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public ArrayList<Fee> getFees() {
        return this.fees;
    }

    public void setFees(ArrayList<Fee> fees) {
        this.fees = fees;
    }

    public String getId() {
        return "";
    }

    public String getMode() {
        return "";
    }

    public List<Shipment> getShipments() {
        return new ArrayList<Shipment>();
    }

    public String getLabelUrl() {
        return "";
    }

    public String getShipmentId() {
        return "";
    }

    public String getTrackingCode() {
        return "";
    }

    public String getStatus() {
        return "";
    }

    public List<TrackingDetail> getTrackingDetails() {
        return new ArrayList<TrackingDetail>();
    }

    protected static enum RequestMethod {
        GET,
        POST,
        DELETE,
        PUT;

    }

    private static class Error {
        private String type;
        private String message;
        private String code;
        private String param;
        private String error;

        private Error() {
        }

        public String getType() {
            return this.type;
        }

        public String getMessage() {
            return this.message;
        }

        public String getCode() {
            return this.code;
        }

        public String getParam() {
            return this.param;
        }

        public String getError() {
            return this.error;
        }
    }

    private static class ErrorContainer {
        private Error error;

        private ErrorContainer() {
        }
    }
}

