/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.app;

import com.easypost.EasyPost;
import com.easypost.exception.EasyPostException;
import com.easypost.model.Address;
import com.easypost.model.Batch;
import com.easypost.model.CustomsInfo;
import com.easypost.model.CustomsItem;
import com.easypost.model.Parcel;
import com.easypost.model.Shipment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class BatchExample {
    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) throws InterruptedException {
        EasyPost.apiKey = System.getenv("EASYPOST_API_KEY");
        try {
            void var18_22;
            Batch batch;
            HashMap<String, Object> fromAddressMap = new HashMap<String, Object>();
            fromAddressMap.put("name", "Simpler Postage Inc");
            fromAddressMap.put("street1", "388 Townsend St");
            fromAddressMap.put("street2", "Apt 20");
            fromAddressMap.put("city", "San Francisco");
            fromAddressMap.put("state", "CA");
            fromAddressMap.put("zip", "94107");
            fromAddressMap.put("phone", "415-456-7890");
            Address fromAddress = Address.create(fromAddressMap);
            HashMap<String, Object> parcelMap = new HashMap<String, Object>();
            parcelMap.put("weight", 22.9);
            parcelMap.put("height", 12.1);
            parcelMap.put("width", 8);
            parcelMap.put("length", 19.8);
            Parcel parcel = Parcel.create(parcelMap);
            HashMap<String, Object> customsItem1Map = new HashMap<String, Object>();
            customsItem1Map.put("description", "EasyPost T-shirts");
            customsItem1Map.put("quantity", 2);
            customsItem1Map.put("value", 23.56);
            customsItem1Map.put("weight", 18.8);
            customsItem1Map.put("origin_country", "us");
            customsItem1Map.put("hs_tariff_number", "610910");
            HashMap<String, Object> customsItem2Map = new HashMap<String, Object>();
            customsItem2Map.put("description", "EasyPost Stickers");
            customsItem2Map.put("quantity", 11);
            customsItem2Map.put("value", 8.98);
            customsItem2Map.put("weight", 3.2);
            customsItem2Map.put("origin_country", "us");
            customsItem2Map.put("hs_tariff_number", "654321");
            HashMap<String, Object> customsInfoMap = new HashMap<String, Object>();
            customsInfoMap.put("customs_certify", true);
            customsInfoMap.put("customs_signer", "Dr. Pepper");
            customsInfoMap.put("contents_type", "gift");
            customsInfoMap.put("eel_pfc", "NOEEI 30.37(a)");
            customsInfoMap.put("non_delivery_option", "return");
            customsInfoMap.put("restriction_type", "none");
            CustomsItem customsItem1 = CustomsItem.create(customsItem1Map);
            CustomsItem customsItem2 = CustomsItem.create(customsItem2Map);
            ArrayList<CustomsItem> customsItemsList = new ArrayList<CustomsItem>();
            customsItemsList.add(customsItem1);
            customsItemsList.add(customsItem2);
            customsInfoMap.put("customs_items", customsItemsList);
            CustomsInfo customsInfo = CustomsInfo.create(customsInfoMap);
            ArrayList orders = new ArrayList();
            HashMap<String, String> sampleOrder = new HashMap<String, String>();
            sampleOrder.put("name", "Sawyer Bateman");
            sampleOrder.put("street1", "1A Larkspur Cres");
            sampleOrder.put("street2", "");
            sampleOrder.put("city", "St. Albert");
            sampleOrder.put("state", "AB");
            sampleOrder.put("zip", "T8N2M4");
            sampleOrder.put("phone", "780-483-2746");
            sampleOrder.put("country", "CA");
            sampleOrder.put("reference", "reference_number_123456");
            orders.add(sampleOrder);
            ArrayList shipments = new ArrayList();
            HashMap<String, Object> shipment = new HashMap<String, Object>();
            HashMap toAddressMap = new HashMap();
            for (Map map : orders) {
                toAddressMap.put("name", map.get("name"));
                toAddressMap.put("street1", map.get("street1"));
                toAddressMap.put("street2", map.get("street2"));
                toAddressMap.put("city", map.get("city"));
                toAddressMap.put("state", map.get("state"));
                toAddressMap.put("zip", map.get("zip"));
                toAddressMap.put("phone", map.get("phone"));
                toAddressMap.put("country", map.get("country"));
                shipment.put("to_address", toAddressMap);
                shipment.put("from_address", fromAddress);
                shipment.put("parcel", parcel);
                shipment.put("customs_info", customsInfo);
                shipment.put("reference", map.get("reference"));
                shipments.add(shipment);
            }
            HashMap<String, Object> batchMap = new HashMap<String, Object>();
            batchMap.put("shipment", shipments);
            Batch batch2 = Batch.create(batchMap);
            for (Shipment createdShipment : batch2.getShipments()) {
                createdShipment = createdShipment.newRates();
                ArrayList<String> buyCarriers = new ArrayList<String>();
                buyCarriers.add("USPS");
                createdShipment.buy(createdShipment.lowestRate(buyCarriers));
            }
            Batch batch3 = batch2.refresh();
            if (batch3.getBatchStatus().getPostagePurchased() == batch3.getShipments().size()) {
                HashMap<String, Object> labelMap = new HashMap<String, Object>();
                labelMap.put("file_format", "pdf");
                batch3.label(labelMap);
            } else {
                System.out.println("Uh oh");
            }
            while ((batch = var18_22.refresh()).getLabelUrl() == null) {
                Thread.sleep(5000L);
            }
            System.out.println(batch.prettyPrint());
        }
        catch (EasyPostException e) {
            e.printStackTrace();
        }
    }
}

