/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.model;

import com.easypost.EasyPost;
import com.easypost.exception.EasyPostException;
import com.easypost.model.ReportCollection;
import com.easypost.net.EasyPostResource;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public final class Report
extends EasyPostResource {
    private String id;
    private Date startDate;
    private Date endDate;
    private String mode;
    private String status;
    private Boolean includeChildren;
    private String url;
    private Date urlExpiresAt;

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Boolean getIncludeChildren() {
        return this.includeChildren;
    }

    public void setIncludeChildren(Boolean includeChildren) {
        this.includeChildren = includeChildren;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Date getUrlExpiresAt() {
        return this.urlExpiresAt;
    }

    public void setUrlExpiresAt(Date urlExpiresAt) {
        this.urlExpiresAt = urlExpiresAt;
    }

    public static Report create(Map<String, Object> params) throws EasyPostException {
        return Report.create(params, null);
    }

    public static Report create(Map<String, Object> params, String apiKey) throws EasyPostException {
        if (params.containsKey("type")) {
            HashMap<String, Object> paramsWithoutType = new HashMap<String, Object>(params);
            paramsWithoutType.remove("type");
            return Report.request(EasyPostResource.RequestMethod.POST, Report.reportURL((String)params.get("type")), paramsWithoutType, Report.class, apiKey);
        }
        throw new EasyPostException("Report type is required.");
    }

    protected static String reportURL(String type) throws EasyPostException {
        try {
            String urlType = URLEncoder.encode(type, "UTF-8").toLowerCase();
            return String.format("%s/reports/%s/", EasyPost.API_BASE, urlType);
        }
        catch (UnsupportedEncodingException e) {
            throw new EasyPostException("Undetermined Report Type");
        }
    }

    public static Report retrieve(String id) throws EasyPostException {
        return Report.retrieve(id, null);
    }

    public static Report retrieve(String id, String apiKey) throws EasyPostException {
        return Report.request(EasyPostResource.RequestMethod.GET, Report.instanceURL(Report.class, id), null, Report.class, apiKey);
    }

    public static ReportCollection all(Map<String, Object> params) throws EasyPostException {
        return Report.all(params, null);
    }

    public static ReportCollection all(Map<String, Object> params, String apiKey) throws EasyPostException {
        String type = (String)params.get("type");
        return Report.request(EasyPostResource.RequestMethod.GET, Report.reportURL(type), params, ReportCollection.class, apiKey);
    }
}

