/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.model;

import com.easypost.EasyPost;
import com.easypost.exception.EasyPostException;
import com.easypost.model.PaymentMethod;
import com.easypost.model.PaymentMethodObject;
import com.easypost.net.EasyPostResource;
import java.util.HashMap;

public final class Billing
extends EasyPostResource {
    public static boolean deletePaymentMethod(PaymentMethod.Priority priority) throws EasyPostException {
        return Billing.deletePaymentMethod(priority, null);
    }

    public static boolean deletePaymentMethod(PaymentMethod.Priority priority, String apiKey) throws EasyPostException {
        PaymentMethodObject paymentMethodObject = Billing.getPaymentMethodByPriority(priority, apiKey);
        Billing.request(EasyPostResource.RequestMethod.DELETE, String.format("%s/%s/%s", EasyPost.API_BASE, paymentMethodObject.getEndpoint(), paymentMethodObject.getId()), null, PaymentMethod.class, apiKey);
        return true;
    }

    public static boolean fundWallet(String amount) throws EasyPostException {
        return Billing.fundWallet(amount, PaymentMethod.Priority.PRIMARY, null);
    }

    public static boolean fundWallet(String amount, PaymentMethod.Priority priority) throws EasyPostException {
        return Billing.fundWallet(amount, priority, null);
    }

    public static boolean fundWallet(String amount, PaymentMethod.Priority priority, String apiKey) throws EasyPostException {
        PaymentMethodObject paymentMethodObject = Billing.getPaymentMethodByPriority(priority, apiKey);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("amount", amount);
        Billing.request(EasyPostResource.RequestMethod.POST, String.format("%s/%s/%s/%s", EasyPost.API_BASE, paymentMethodObject.getEndpoint(), paymentMethodObject.getId(), "charges"), params, PaymentMethod.class, apiKey);
        return true;
    }

    public static PaymentMethod retrievePaymentMethods() throws EasyPostException {
        return Billing.retrievePaymentMethods(null);
    }

    public static PaymentMethod retrievePaymentMethods(String apiKey) throws EasyPostException {
        PaymentMethod response = Billing.request(EasyPostResource.RequestMethod.GET, String.format("%s/%s", EasyPost.API_BASE, "payment_methods"), null, PaymentMethod.class, apiKey);
        if (response.getId() == null) {
            throw new EasyPostException("Billing has not been setup for this user. Please add a payment method.");
        }
        return response;
    }

    private static PaymentMethodObject getPaymentMethodByPriority(PaymentMethod.Priority priority, String apiKey) throws EasyPostException {
        PaymentMethod paymentMethods = Billing.retrievePaymentMethods(apiKey);
        PaymentMethodObject paymentMethod = null;
        switch (priority) {
            case PRIMARY: {
                paymentMethod = paymentMethods.getPrimaryPaymentMethodObject();
                break;
            }
            case SECONDARY: {
                paymentMethod = paymentMethods.getSecondaryPaymentMethodObject();
                break;
            }
        }
        if (paymentMethod == null || paymentMethod.getId() == null) {
            throw new EasyPostException("The chosen payment method is not set up yet.");
        }
        return paymentMethod;
    }
}

