/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.model;

import com.easypost.exception.EasyPostException;
import com.easypost.model.ApiKey;
import com.easypost.model.ApiKeys;
import com.easypost.model.BaseUser;
import com.easypost.model.Brand;
import com.easypost.net.EasyPostResource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class User
extends BaseUser {
    public static User retrieve(String id) throws EasyPostException {
        return User.retrieve(id, null);
    }

    public static User retrieve(String id, String apiKey) throws EasyPostException {
        return User.request(EasyPostResource.RequestMethod.GET, User.instanceURL(User.class, id), null, User.class, apiKey);
    }

    public static User retrieveMe() throws EasyPostException {
        return User.retrieveMe(null);
    }

    public static User retrieveMe(String apiKey) throws EasyPostException {
        return User.request(EasyPostResource.RequestMethod.GET, User.classURL(User.class), null, User.class, apiKey);
    }

    public static User create() throws EasyPostException {
        return User.create(null, null);
    }

    public static User create(Map<String, Object> params, String apiKey) throws EasyPostException {
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        wrappedParams.put("user", params);
        return User.request(EasyPostResource.RequestMethod.POST, User.classURL(User.class), wrappedParams, User.class, apiKey);
    }

    public static User create(Map<String, Object> params) throws EasyPostException {
        return User.create(params, null);
    }

    public User update(Map<String, Object> params) throws EasyPostException {
        return this.update(params, null);
    }

    public User update(Map<String, Object> params, String apiKey) throws EasyPostException {
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        wrappedParams.put("user", params);
        User response = User.request(EasyPostResource.RequestMethod.PUT, User.instanceURL(User.class, this.getId()), wrappedParams, User.class, apiKey);
        this.merge(this, response);
        return this;
    }

    public void delete() throws EasyPostException {
        this.delete(null);
    }

    public void delete(String apiKey) throws EasyPostException {
        User.request(EasyPostResource.RequestMethod.DELETE, User.instanceURL(User.class, this.getId()), null, User.class, apiKey);
    }

    public List<ApiKey> apiKeys() throws EasyPostException {
        ApiKeys parentKeys = ApiKeys.all();
        if (Objects.equals(this.getId(), parentKeys.getId())) {
            return parentKeys.getKeys();
        }
        for (int i = 0; i < parentKeys.getChildren().size(); ++i) {
            if (!this.getId().equals(parentKeys.getChildren().get(i).getId())) continue;
            return parentKeys.getChildren().get(i).getKeys();
        }
        throw new EasyPostException(String.format("Unable to find api key. Please contact %s.", "support@easypost.com"));
    }

    public Brand updateBrand(Map<String, Object> params) throws EasyPostException {
        return this.updateBrand(params, null);
    }

    public Brand updateBrand(Map<String, Object> params, String apiKey) throws EasyPostException {
        String updateBrandUrl = String.format("%s/brand", User.instanceURL(User.class, this.getId()));
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        wrappedParams.put("brand", params);
        return User.request(EasyPostResource.RequestMethod.PUT, updateBrandUrl, wrappedParams, Brand.class, apiKey);
    }
}

