/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.model;

import com.easypost.exception.EasyPostException;
import com.easypost.model.Event;
import com.easypost.model.WebhookCollection;
import com.easypost.net.EasyPostResource;
import com.easypost.utils.Cryptography;
import java.nio.charset.StandardCharsets;
import java.text.Normalizer;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public final class Webhook
extends EasyPostResource {
    private String id;
    private String mode;
    private String url;
    private Date disabledAt;

    public Date getDisabledAt() {
        return this.disabledAt;
    }

    public void setDisabledAt(Date disabledAt) {
        this.disabledAt = disabledAt;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public static Webhook create(Map<String, Object> params) throws EasyPostException {
        return Webhook.create(params, null);
    }

    public static Webhook create(Map<String, Object> params, String apiKey) throws EasyPostException {
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        wrappedParams.put("webhook", params);
        return Webhook.request(EasyPostResource.RequestMethod.POST, Webhook.classURL(Webhook.class), wrappedParams, Webhook.class, apiKey);
    }

    public static Webhook retrieve(String id) throws EasyPostException {
        return Webhook.retrieve(id, null);
    }

    public static Webhook retrieve(String id, String apiKey) throws EasyPostException {
        return Webhook.request(EasyPostResource.RequestMethod.GET, Webhook.instanceURL(Webhook.class, id), null, Webhook.class, apiKey);
    }

    public static WebhookCollection all() throws EasyPostException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        return Webhook.all(params, null);
    }

    public static WebhookCollection all(Map<String, Object> params, String apiKey) throws EasyPostException {
        return Webhook.request(EasyPostResource.RequestMethod.GET, Webhook.classURL(Webhook.class), params, WebhookCollection.class, apiKey);
    }

    public static WebhookCollection all(Map<String, Object> params) throws EasyPostException {
        return Webhook.all(params, null);
    }

    public void delete() throws EasyPostException {
        this.delete(null);
    }

    public void delete(String apiKey) throws EasyPostException {
        Webhook.request(EasyPostResource.RequestMethod.DELETE, Webhook.instanceURL(Webhook.class, this.getId()), null, Webhook.class, apiKey);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public Webhook update() throws EasyPostException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        return this.update(params, null);
    }

    public Webhook update(Map<String, Object> params, String apiKey) throws EasyPostException {
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        wrappedParams.put("webhook", params);
        Webhook response = Webhook.request(EasyPostResource.RequestMethod.PUT, Webhook.instanceURL(Webhook.class, this.getId()), wrappedParams, Webhook.class, apiKey);
        this.merge(this, response);
        return this;
    }

    public Webhook update(Map<String, Object> params) throws EasyPostException {
        return this.update(params, null);
    }

    public static Event validateWebhook(byte[] eventBody, Map<String, Object> headers, String webhookSecret) throws EasyPostException {
        String providedSignature = null;
        try {
            providedSignature = headers.get("X-Hmac-Signature").toString();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (providedSignature != null) {
            String calculatedDigest = Cryptography.toHMACSHA256HexDigest(eventBody, webhookSecret, Normalizer.Form.NFKD);
            String calculatedSignature = "hmac-sha256-hex=" + calculatedDigest;
            if (Cryptography.signaturesMatch(providedSignature, calculatedSignature)) {
                String json = new String(eventBody, StandardCharsets.UTF_8);
                return (Event)GSON.fromJson(json, Event.class);
            }
            throw new EasyPostException("Webhook received did not originate from EasyPost or had a webhook secret mismatch.");
        }
        throw new EasyPostException("Webhook received does not contain an HMAC signature.");
    }
}

