/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.model;

import com.easypost.model.Address;
import com.easypost.model.Batch;
import com.easypost.model.CustomsInfo;
import com.easypost.model.CustomsItem;
import com.easypost.model.Event;
import com.easypost.model.Fee;
import com.easypost.model.Parcel;
import com.easypost.model.PostageLabel;
import com.easypost.model.Rate;
import com.easypost.model.Refund;
import com.easypost.model.ScanForm;
import com.easypost.model.Shipment;
import com.easypost.model.TimeInTransit;
import com.easypost.model.Tracker;
import com.easypost.model.TrackingDetail;
import com.easypost.model.Webhook;
import com.easypost.net.EasyPostResource;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class EventDeserializer
implements JsonDeserializer<Event> {
    private static final Map<String, Class> OBJECT_MAP = new HashMap<String, Class>();

    private Object deserializeJsonPrimitive(JsonPrimitive element) {
        if (element.isBoolean()) {
            return element.getAsBoolean();
        }
        if (element.isNumber()) {
            return element.getAsNumber();
        }
        return element.getAsString();
    }

    private Object[] deserializeJsonArray(JsonArray arr) {
        Object[] elems = new Object[arr.size()];
        Iterator elemIter = arr.iterator();
        int i = 0;
        while (elemIter.hasNext()) {
            JsonElement elem = (JsonElement)elemIter.next();
            elems[i++] = this.deserializeJsonElement(elem);
        }
        return elems;
    }

    private Object deserializeJsonElement(JsonElement element) {
        if (element.isJsonNull()) {
            return null;
        }
        if (element.isJsonObject()) {
            HashMap<String, Object> valueMap = new HashMap<String, Object>();
            this.populateMapFromJSONObject(valueMap, element.getAsJsonObject());
            return valueMap;
        }
        if (element.isJsonPrimitive()) {
            return this.deserializeJsonPrimitive(element.getAsJsonPrimitive());
        }
        if (element.isJsonArray()) {
            return this.deserializeJsonArray(element.getAsJsonArray());
        }
        System.err.printf("Unknown JSON element type for element %s. Please email us at %s.%n", element, "support@easypost.com");
        return null;
    }

    private void populateMapFromJSONObject(Map<String, Object> objMap, JsonObject jsonObject) {
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement element = (JsonElement)entry.getValue();
            objMap.put(key, this.deserializeJsonElement(element));
        }
    }

    public Event deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Event event = new Event();
        JsonObject jsonObject = json.getAsJsonObject();
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement element = (JsonElement)entry.getValue();
            if ("previous_attributes".equals(key) && !element.isJsonNull()) {
                HashMap<String, Object> previousAttributes = new HashMap<String, Object>();
                this.populateMapFromJSONObject(previousAttributes, element.getAsJsonObject());
                event.setPreviousAttributes(previousAttributes);
                continue;
            }
            if (!"result".equals(key)) continue;
            String type = element.getAsJsonObject().get("object").getAsString();
            Class cl = OBJECT_MAP.get(type);
            EasyPostResource result = (EasyPostResource)EasyPostResource.GSON.fromJson((JsonElement)entry.getValue(), cl);
            event.setResult(result);
        }
        event.setId(jsonObject.get("id").getAsString());
        event.setDescription(jsonObject.get("description").getAsString());
        event.setMode(jsonObject.get("mode").getAsString());
        return event;
    }

    static {
        OBJECT_MAP.put("Address", Address.class);
        OBJECT_MAP.put("Batch", Batch.class);
        OBJECT_MAP.put("CustomsInfo", CustomsInfo.class);
        OBJECT_MAP.put("CustomsItem", CustomsItem.class);
        OBJECT_MAP.put("Event", Event.class);
        OBJECT_MAP.put("Fee", Fee.class);
        OBJECT_MAP.put("Parcel", Parcel.class);
        OBJECT_MAP.put("PostageLabel", PostageLabel.class);
        OBJECT_MAP.put("Rate", Rate.class);
        OBJECT_MAP.put("Refund", Refund.class);
        OBJECT_MAP.put("ScanForm", ScanForm.class);
        OBJECT_MAP.put("Shipment", Shipment.class);
        OBJECT_MAP.put("TimeInTransit", TimeInTransit.class);
        OBJECT_MAP.put("Tracker", Tracker.class);
        OBJECT_MAP.put("TrackingDetail", TrackingDetail.class);
        OBJECT_MAP.put("Webhook", Webhook.class);
    }
}

