/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.utils;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.Normalizer;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Cryptography {
    public static String hexEncodeToString(byte @NotNull [] bytes) {
        return new String(Hex.encodeHex((byte[])bytes));
    }

    public static char[] hexEncode(byte @NotNull [] bytes) {
        return Hex.encodeHex((byte[])bytes);
    }

    public static String toHMACSHA256HexDigest(byte @NotNull [] data, @NotNull String key, @Nullable Normalizer.Form normalizationForm) {
        if (normalizationForm != null) {
            key = Normalizer.normalize(key, normalizationForm);
        }
        byte[] hmacBytes = Cryptography.createHMAC(data, key, HmacAlgorithm.SHA256);
        return Cryptography.hexEncodeToString(hmacBytes);
    }

    public static String toHMACSHA256HexDigest(@NotNull String data, @NotNull String key, @Nullable Normalizer.Form normalizationForm) {
        byte[] dataBytes = data.getBytes();
        return Cryptography.toHMACSHA256HexDigest(dataBytes, key, normalizationForm);
    }

    public static byte[] createHMAC(byte @NotNull [] data, @NotNull String key, @NotNull HmacAlgorithm algorithm) {
        byte[] keyBytes = key.getBytes(StandardCharsets.UTF_8);
        SecretKeySpec keyHash = new SecretKeySpec(keyBytes, algorithm.algorithmString);
        try {
            Mac hmac = Mac.getInstance(algorithm.algorithmString);
            hmac.init(keyHash);
            return hmac.doFinal(data);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new IllegalStateException("Cannot initialize Mac Generator", e);
        }
    }

    public static boolean signaturesMatch(byte @NotNull [] signature1, byte @NotNull [] signature2) {
        return MessageDigest.isEqual(signature1, signature2);
    }

    public static boolean signaturesMatch(@NotNull String signature1, @NotNull String signature2) {
        byte[] signature1Bytes = signature1.getBytes(StandardCharsets.UTF_8);
        byte[] signature2Bytes = signature2.getBytes(StandardCharsets.UTF_8);
        return Cryptography.signaturesMatch(signature1Bytes, signature2Bytes);
    }

    public static enum HmacAlgorithm {
        MD5("HmacMD5"),
        SHA1("HmacSHA1"),
        SHA256("HmacSHA256"),
        SHA512("HmacSHA512");

        private final String algorithmString;

        private HmacAlgorithm(String algorithmString) {
            this.algorithmString = algorithmString;
        }

        String getAlgorithmString() {
            return this.algorithmString;
        }
    }
}

