/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.service;

import com.easypost.exception.EasyPostException;
import com.easypost.http.Requestor;
import com.easypost.model.Address;
import com.easypost.model.AddressCollection;
import com.easypost.model.AddressVerifyResponse;
import com.easypost.service.EasyPostClient;
import com.easypost.utils.Utilities;
import java.util.HashMap;
import java.util.Map;

public class AddressService {
    private final EasyPostClient client;

    AddressService(EasyPostClient client) {
        this.client = client;
    }

    public Address create(Map<String, Object> params) throws EasyPostException {
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        if (params.containsKey("verify")) {
            wrappedParams.put("verify", params.remove("verify"));
        }
        if (params.containsKey("verify_strict")) {
            wrappedParams.put("verify_strict", params.remove("verify_strict"));
        }
        wrappedParams.put("address", params);
        return Requestor.request(Requestor.RequestMethod.POST, Utilities.classURL(Address.class), wrappedParams, Address.class, this.client);
    }

    public Address retrieve(String id) throws EasyPostException {
        return Requestor.request(Requestor.RequestMethod.GET, Utilities.instanceURL(Address.class, id), null, Address.class, this.client);
    }

    public AddressCollection all(Map<String, Object> params) throws EasyPostException {
        return Requestor.request(Requestor.RequestMethod.GET, Utilities.classURL(Address.class), params, AddressCollection.class, this.client);
    }

    public Address createAndVerify(Map<String, Object> params) throws EasyPostException {
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        wrappedParams.put("address", params);
        String url = String.format("%s/create_and_verify", Utilities.classURL(Address.class));
        AddressVerifyResponse response = Requestor.request(Requestor.RequestMethod.POST, url, wrappedParams, AddressVerifyResponse.class, this.client);
        return response.getAddress();
    }

    public Address verify(String id) throws EasyPostException {
        String url = String.format("%s/verify", Utilities.instanceURL(Address.class, id));
        AddressVerifyResponse response = Requestor.request(Requestor.RequestMethod.GET, url, null, AddressVerifyResponse.class, this.client);
        return response.getAddress();
    }
}

