/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.service;

import com.easypost.exception.EasyPostException;
import com.easypost.exception.General.InvalidObjectError;
import com.easypost.http.Requestor;
import com.easypost.model.PaymentMethod;
import com.easypost.model.PaymentMethodObject;
import com.easypost.service.EasyPostClient;
import java.util.HashMap;

public class BillingService {
    private final EasyPostClient client;

    BillingService(EasyPostClient client) {
        this.client = client;
    }

    public void deletePaymentMethod(PaymentMethod.Priority priority) throws EasyPostException {
        PaymentMethodObject paymentMethodObject = this.getPaymentMethodByPriority(priority);
        String url = String.format("%s/%s/%s/%s", this.client.getApiBase(), this.client.getApiVersion(), paymentMethodObject.getEndpoint(), paymentMethodObject.getId());
        Requestor.request(Requestor.RequestMethod.DELETE, url, null, PaymentMethod.class, this.client);
    }

    public void fundWallet(String amount) throws EasyPostException {
        this.fundWallet(amount, PaymentMethod.Priority.PRIMARY);
    }

    public void fundWallet(String amount, PaymentMethod.Priority priority) throws EasyPostException {
        PaymentMethodObject paymentMethodObject = this.getPaymentMethodByPriority(priority);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("amount", amount);
        String url = String.format("%s/%s/%s/%s/%s", this.client.getApiBase(), this.client.getApiVersion(), paymentMethodObject.getEndpoint(), paymentMethodObject.getId(), "charges");
        Requestor.request(Requestor.RequestMethod.POST, url, params, PaymentMethod.class, this.client);
    }

    public PaymentMethod retrievePaymentMethods() throws EasyPostException {
        String url = String.format("%s/%s/%s", this.client.getApiBase(), this.client.getApiVersion(), "payment_methods");
        PaymentMethod response = Requestor.request(Requestor.RequestMethod.GET, url, null, PaymentMethod.class, this.client);
        if (response.getId() == null) {
            throw new InvalidObjectError("No payment methods are set up. Please add a payment method and try again.");
        }
        return response;
    }

    private PaymentMethodObject getPaymentMethodByPriority(PaymentMethod.Priority priority) throws EasyPostException {
        PaymentMethod paymentMethods = this.retrievePaymentMethods();
        PaymentMethodObject paymentMethod = null;
        switch (priority) {
            case PRIMARY: {
                paymentMethod = paymentMethods.getPrimaryPaymentMethod();
                break;
            }
            case SECONDARY: {
                paymentMethod = paymentMethods.getSecondaryPaymentMethod();
                break;
            }
        }
        if (paymentMethod == null || paymentMethod.getId() == null) {
            throw new InvalidObjectError("No payment methods are set up. Please add a payment method and try again.");
        }
        return paymentMethod;
    }
}

