/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.service;

import com.easypost.exception.EasyPostException;
import com.easypost.http.Requestor;
import com.easypost.model.Order;
import com.easypost.model.Rate;
import com.easypost.service.EasyPostClient;
import com.easypost.utils.Utilities;
import java.util.HashMap;
import java.util.Map;

public class OrderService {
    private final EasyPostClient client;

    OrderService(EasyPostClient client) {
        this.client = client;
    }

    public Order create(Map<String, Object> params) throws EasyPostException {
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        wrappedParams.put("order", params);
        return Requestor.request(Requestor.RequestMethod.POST, Utilities.classURL(Order.class), wrappedParams, Order.class, this.client);
    }

    public Order retrieve(String id) throws EasyPostException {
        return Requestor.request(Requestor.RequestMethod.GET, Utilities.instanceURL(Order.class, id), null, Order.class, this.client);
    }

    public Order newRates(String id) throws EasyPostException {
        return this.newRates(id, null);
    }

    public Order newRates(String id, Map<String, Object> params) throws EasyPostException {
        return Requestor.request(Requestor.RequestMethod.GET, String.format("%s/rates", Utilities.instanceURL(Order.class, id)), params, Order.class, this.client);
    }

    public Order buy(String id, Map<String, Object> params) throws EasyPostException {
        return Requestor.request(Requestor.RequestMethod.POST, String.format("%s/buy", Utilities.instanceURL(Order.class, id)), params, Order.class, this.client);
    }

    public Order buy(String id, Rate rate) throws EasyPostException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("carrier", rate.getCarrier());
        params.put("service", rate.getService());
        return this.buy(id, params);
    }
}

