/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.service;

import com.easypost.exception.EasyPostException;
import com.easypost.http.Requestor;
import com.easypost.model.Pickup;
import com.easypost.model.PickupRate;
import com.easypost.service.EasyPostClient;
import com.easypost.utils.Utilities;
import java.util.HashMap;
import java.util.Map;

public class PickupService {
    private final EasyPostClient client;

    PickupService(EasyPostClient client) {
        this.client = client;
    }

    public Pickup create(Map<String, Object> params) throws EasyPostException {
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        wrappedParams.put("pickup", params);
        return Requestor.request(Requestor.RequestMethod.POST, Utilities.classURL(Pickup.class), wrappedParams, Pickup.class, this.client);
    }

    public Pickup retrieve(String id) throws EasyPostException {
        return Requestor.request(Requestor.RequestMethod.GET, Utilities.instanceURL(Pickup.class, id), null, Pickup.class, this.client);
    }

    public Pickup buy(String id) throws EasyPostException {
        return this.buy(id, new HashMap<String, Object>());
    }

    public Pickup buy(String id, Map<String, Object> params) throws EasyPostException {
        String url = String.format("%s/buy", Utilities.instanceURL(Pickup.class, id));
        return Requestor.request(Requestor.RequestMethod.POST, url, params, Pickup.class, this.client);
    }

    public Pickup buy(String id, PickupRate pickupRate) throws EasyPostException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("rate", pickupRate);
        return this.buy(id, params);
    }

    public Pickup cancel(String id) throws EasyPostException {
        return this.cancel(id, null);
    }

    public Pickup cancel(String id, Map<String, Object> params) throws EasyPostException {
        String url = String.format("%s/cancel", Utilities.instanceURL(Pickup.class, id));
        return Requestor.request(Requestor.RequestMethod.POST, url, params, Pickup.class, this.client);
    }
}

