/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.service;

import com.easypost.exception.EasyPostException;
import com.easypost.exception.General.InvalidObjectError;
import com.easypost.exception.General.InvalidParameterError;
import com.easypost.http.Requestor;
import com.easypost.model.Report;
import com.easypost.model.ReportCollection;
import com.easypost.service.EasyPostClient;
import com.easypost.utils.Utilities;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public class ReportService {
    private final EasyPostClient client;

    ReportService(EasyPostClient client) {
        this.client = client;
    }

    public Report create(Map<String, Object> params) throws EasyPostException {
        if (params.containsKey("type")) {
            HashMap<String, Object> paramsWithoutType = new HashMap<String, Object>(params);
            paramsWithoutType.remove("type");
            return Requestor.request(Requestor.RequestMethod.POST, this.reportURL((String)params.get("type")), paramsWithoutType, Report.class, this.client);
        }
        throw new InvalidObjectError(String.format("Missing required parameter: %s.", "type"));
    }

    protected String reportURL(String type) throws EasyPostException {
        try {
            String urlType = URLEncoder.encode(type, "UTF-8").toLowerCase();
            return String.format("%s/%s/reports/%s/", this.client.getApiBase(), this.client.getApiVersion(), urlType);
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidParameterError(String.format("Encode error for %s", "report type"), e);
        }
    }

    public Report retrieve(String id) throws EasyPostException {
        return Requestor.request(Requestor.RequestMethod.GET, Utilities.instanceURL(Report.class, id), null, Report.class, this.client);
    }

    public ReportCollection all(Map<String, Object> params) throws EasyPostException {
        String type = (String)params.get("type");
        return Requestor.request(Requestor.RequestMethod.GET, this.reportURL(type), params, ReportCollection.class, this.client);
    }
}

