/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.service;

import com.easypost.exception.EasyPostException;
import com.easypost.exception.General.FilteringError;
import com.easypost.http.Requestor;
import com.easypost.model.ApiKey;
import com.easypost.model.ApiKeys;
import com.easypost.model.Brand;
import com.easypost.model.User;
import com.easypost.service.EasyPostClient;
import com.easypost.utils.Utilities;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class UserService {
    private final EasyPostClient client;

    UserService(EasyPostClient client) {
        this.client = client;
    }

    public User retrieve(String id) throws EasyPostException {
        return Requestor.request(Requestor.RequestMethod.GET, Utilities.instanceURL(User.class, id), null, User.class, this.client);
    }

    public User retrieveMe() throws EasyPostException {
        return Requestor.request(Requestor.RequestMethod.GET, Utilities.classURL(User.class), null, User.class, this.client);
    }

    public User create(Map<String, Object> params) throws EasyPostException {
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        wrappedParams.put("user", params);
        return Requestor.request(Requestor.RequestMethod.POST, Utilities.classURL(User.class), wrappedParams, User.class, this.client);
    }

    public User update(String id, Map<String, Object> params) throws EasyPostException {
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        wrappedParams.put("user", params);
        return Requestor.request(Requestor.RequestMethod.PUT, Utilities.instanceURL(User.class, id), wrappedParams, User.class, this.client);
    }

    public void delete(String id) throws EasyPostException {
        Requestor.request(Requestor.RequestMethod.DELETE, Utilities.instanceURL(User.class, id), null, User.class, this.client);
    }

    public List<ApiKey> apiKeys(String id) throws EasyPostException {
        ApiKeys parentKeys = this.client.apikeys.all();
        if (Objects.equals(id, parentKeys.getId())) {
            return parentKeys.getKeys();
        }
        for (int i = 0; i < parentKeys.getChildren().size(); ++i) {
            if (!id.equals(parentKeys.getChildren().get(i).getId())) continue;
            return parentKeys.getChildren().get(i).getKeys();
        }
        throw new FilteringError(String.format("No %s found.", "API keys"));
    }

    public Brand updateBrand(String id, Map<String, Object> params) throws EasyPostException {
        String updateBrandUrl = String.format("%s/brand", Utilities.instanceURL(User.class, id));
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        wrappedParams.put("brand", params);
        return Requestor.request(Requestor.RequestMethod.PUT, updateBrandUrl, wrappedParams, Brand.class, this.client);
    }
}

