/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.service;

import com.easypost.exception.EasyPostException;
import com.easypost.exception.General.SignatureVerificationError;
import com.easypost.http.Constant;
import com.easypost.http.Requestor;
import com.easypost.model.Event;
import com.easypost.model.Webhook;
import com.easypost.model.WebhookCollection;
import com.easypost.service.EasyPostClient;
import com.easypost.utils.Cryptography;
import com.easypost.utils.Utilities;
import java.nio.charset.StandardCharsets;
import java.text.Normalizer;
import java.util.HashMap;
import java.util.Map;

public class WebhookService {
    private final EasyPostClient client;

    WebhookService(EasyPostClient client) {
        this.client = client;
    }

    public Webhook create(Map<String, Object> params) throws EasyPostException {
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        wrappedParams.put("webhook", params);
        return Requestor.request(Requestor.RequestMethod.POST, Utilities.classURL(Webhook.class), wrappedParams, Webhook.class, this.client);
    }

    public Webhook retrieve(String id) throws EasyPostException {
        return Requestor.request(Requestor.RequestMethod.GET, Utilities.instanceURL(Webhook.class, id), null, Webhook.class, this.client);
    }

    public WebhookCollection all() throws EasyPostException {
        return this.all(null);
    }

    public WebhookCollection all(Map<String, Object> params) throws EasyPostException {
        return Requestor.request(Requestor.RequestMethod.GET, Utilities.classURL(Webhook.class), params, WebhookCollection.class, this.client);
    }

    public void delete(String id) throws EasyPostException {
        Requestor.request(Requestor.RequestMethod.DELETE, Utilities.instanceURL(Webhook.class, id), null, Webhook.class, this.client);
    }

    public Webhook update(String id) throws EasyPostException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        return this.update(id, params);
    }

    public Webhook update(String id, Map<String, Object> params) throws EasyPostException {
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        wrappedParams.put("webhook", params);
        return Requestor.request(Requestor.RequestMethod.PUT, Utilities.instanceURL(Webhook.class, id), wrappedParams, Webhook.class, this.client);
    }

    public Event validateWebhook(byte[] eventBody, Map<String, Object> headers, String webhookSecret) throws EasyPostException {
        String providedSignature = null;
        try {
            providedSignature = headers.get("X-Hmac-Signature").toString();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (providedSignature != null) {
            String calculatedDigest = Cryptography.toHMACSHA256HexDigest(eventBody, webhookSecret, Normalizer.Form.NFKD);
            String calculatedSignature = "hmac-sha256-hex=" + calculatedDigest;
            if (Cryptography.signaturesMatch(providedSignature, calculatedSignature)) {
                String json = new String(eventBody, StandardCharsets.UTF_8);
                return (Event)Constant.GSON.fromJson(json, Event.class);
            }
            throw new SignatureVerificationError("Webhook received did not originate from EasyPost or had a webhook secret mismatch.");
        }
        throw new SignatureVerificationError("Webhook does not contain a valid HMAC signature.");
    }
}

