/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.utils;

import com.easypost.exception.EasyPostException;
import com.easypost.exception.General.FilteringError;
import com.easypost.model.Rate;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;

public abstract class Utilities {
    public static Rate getLowestObjectRate(List<Rate> rates, List<String> carriers, List<String> services) throws EasyPostException {
        int i;
        Rate lowestRate = null;
        if (carriers != null) {
            for (i = 0; i < carriers.size(); ++i) {
                carriers.set(i, carriers.get(i).toLowerCase());
            }
        }
        if (services != null) {
            for (i = 0; i < services.size(); ++i) {
                services.set(i, services.get(i).toLowerCase());
            }
        }
        for (Rate rate : rates) {
            if (carriers != null && !carriers.contains(rate.getCarrier().toLowerCase()) || services != null && !services.contains(rate.getService().toLowerCase()) || lowestRate != null && !(rate.getRate().floatValue() < lowestRate.getRate().floatValue())) continue;
            lowestRate = rate;
        }
        if (lowestRate == null) {
            throw new FilteringError(String.format("No %s found.", "lowest rate matching required criteria"));
        }
        return lowestRate;
    }

    public static String getEncodedURL(Map<String, String> params, String parentKey) throws Exception {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        try {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    result.append("&");
                }
                result.append(URLEncoder.encode(parentKey + "[" + entry.getKey() + "]", "UTF-8"));
                result.append("=");
                result.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
            }
        }
        catch (Exception e) {
            throw new Exception("Something went wrong during the URL encoding.");
        }
        return result.toString();
    }

    public static String instanceURL(Class<?> clazz, String id) {
        return String.format("%s/%s", Utilities.classURL(clazz), id);
    }

    public static String classURL(Class<?> clazz) {
        String singleURL = Utilities.singleClassURL(clazz);
        if (singleURL.charAt(singleURL.length() - 1) == 's' || singleURL.charAt(singleURL.length() - 1) == 'h') {
            return String.format("%ses", Utilities.singleClassURL(clazz));
        }
        return String.format("%ss", Utilities.singleClassURL(clazz));
    }

    private static String singleClassURL(Class<?> clazz) {
        return String.format("%s/%s", "%s/%s", Utilities.className(clazz));
    }

    private static String className(Class<?> clazz) {
        return clazz.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase().replace("$", "");
    }
}

