/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.model;

import com.easypost.model.Error;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Type;
import java.util.ArrayList;

public final class ErrorDeserializer
implements JsonDeserializer<Error> {
    public Error deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jo = json.getAsJsonObject();
        JsonElement results = jo.get("error");
        Gson gson = new Gson();
        if (results == null) {
            Error error = new Error();
            error.setMessage("API did not return error details.");
            error.setCode("NO RESPONSE CODE");
            return error;
        }
        JsonElement errorMessage = results.getAsJsonObject().get("message");
        if (errorMessage.isJsonArray()) {
            JsonArray jsonArray = errorMessage.getAsJsonArray();
            ArrayList<String> messages = new ArrayList<String>();
            for (int i = 0; i < jsonArray.size(); ++i) {
                messages.add(jsonArray.get(i).getAsString());
            }
            JsonPrimitive value = new JsonPrimitive(String.join((CharSequence)", ", messages));
            results.getAsJsonObject().add("message", (JsonElement)value);
        }
        return (Error)gson.fromJson(results, Error.class);
    }
}

