/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.model;

import com.easypost.model.EasyPostResource;

public class PaymentMethodObject
extends EasyPostResource {
    private String country;
    private String bankName;
    private String brand;
    private String disabledAt;
    private int expMonth;
    private int expYear;
    private String last4;
    private String name;
    private String object;
    private boolean verified;

    public PaymentMethodType getType() {
        PaymentMethodType type = null;
        if (this.getId() == null) {
            return null;
        }
        if (this.getId().startsWith("card_")) {
            type = PaymentMethodType.CREDIT_CARD;
        } else if (this.getId().startsWith("bank_")) {
            type = PaymentMethodType.BANK_ACCOUNT;
        }
        return type;
    }

    public String getEndpoint() {
        PaymentMethodType type = this.getType();
        if (type == null) {
            return null;
        }
        return type.getEndpoint();
    }

    public String getCountry() {
        return this.country;
    }

    public String getBankName() {
        return this.bankName;
    }

    public String getBrand() {
        return this.brand;
    }

    public String getDisabledAt() {
        return this.disabledAt;
    }

    public int getExpMonth() {
        return this.expMonth;
    }

    public int getExpYear() {
        return this.expYear;
    }

    public String getLast4() {
        return this.last4;
    }

    public String getName() {
        return this.name;
    }

    public String getObject() {
        return this.object;
    }

    public boolean isVerified() {
        return this.verified;
    }

    public static enum PaymentMethodType {
        CREDIT_CARD("credit_cards"),
        BANK_ACCOUNT("bank_accounts");

        private final String endpoint;

        private PaymentMethodType(String endpoint) {
            this.endpoint = endpoint;
        }

        String getEndpoint() {
            return this.endpoint;
        }
    }
}

