/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.service;

import com.easypost.exception.EasyPostException;
import com.easypost.http.Requestor;
import com.easypost.model.BetaPaymentRefund;
import com.easypost.model.PaymentMethod;
import com.easypost.model.PaymentMethodObject;
import com.easypost.service.EasyPostClient;
import java.util.HashMap;

public class BetaReferralCustomerService {
    private final EasyPostClient client;

    BetaReferralCustomerService(EasyPostClient client) {
        this.client = client;
    }

    public PaymentMethodObject addPaymentMethod(String stripeCustomerId, String paymentMethodReference) throws EasyPostException {
        return this.addPaymentMethod(stripeCustomerId, paymentMethodReference, PaymentMethod.Priority.PRIMARY);
    }

    public PaymentMethodObject addPaymentMethod(String stripeCustomerId, String paymentMethodReference, PaymentMethod.Priority primaryOrSecondary) throws EasyPostException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("stripe_customer_id", stripeCustomerId);
        params.put("payment_method_reference", paymentMethodReference);
        params.put("priority", (Object)primaryOrSecondary);
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        wrappedParams.put("payment_method", params);
        return Requestor.request(Requestor.RequestMethod.POST, "%s/beta/referral_customers/payment_method", wrappedParams, PaymentMethodObject.class, this.client);
    }

    public BetaPaymentRefund refundByAmount(int refundAmount) throws EasyPostException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("refund_amount", refundAmount);
        return Requestor.request(Requestor.RequestMethod.POST, "%s/beta/referral_customers/refunds", params, BetaPaymentRefund.class, this.client);
    }

    public BetaPaymentRefund refundByPaymentLog(String paymentLogId) throws EasyPostException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("payment_log_id", paymentLogId);
        return Requestor.request(Requestor.RequestMethod.POST, "%s/beta/referral_customers/refunds", params, BetaPaymentRefund.class, this.client);
    }
}

