/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.service;

import com.easypost.Constants;
import com.easypost.exception.EasyPostException;
import com.easypost.exception.General.MissingParameterError;
import com.easypost.http.Requestor;
import com.easypost.model.CarrierAccount;
import com.easypost.service.EasyPostClient;
import com.easypost.utils.InternalUtilities;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CarrierAccountService {
    private final EasyPostClient client;

    CarrierAccountService(EasyPostClient client) {
        this.client = client;
    }

    public CarrierAccount create(Map<String, Object> params) throws EasyPostException {
        String type = (String)params.get("type");
        if (type == null) {
            throw new MissingParameterError(String.format("Missing required parameter: %s.", "carrier account type"));
        }
        String endpoint = CarrierAccountService.selectCarrierAccountCreationEndpoint(type);
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        wrappedParams.put("carrier_account", params);
        return Requestor.request(Requestor.RequestMethod.POST, endpoint, wrappedParams, CarrierAccount.class, this.client);
    }

    public CarrierAccount retrieve(String id) throws EasyPostException {
        return Requestor.request(Requestor.RequestMethod.GET, InternalUtilities.instanceURL(CarrierAccount.class, id), null, CarrierAccount.class, this.client);
    }

    public List<CarrierAccount> all() throws EasyPostException {
        return this.all(null);
    }

    public List<CarrierAccount> all(Map<String, Object> params) throws EasyPostException {
        CarrierAccount[] response = Requestor.request(Requestor.RequestMethod.GET, InternalUtilities.classURL(CarrierAccount.class), params, CarrierAccount[].class, this.client);
        return Arrays.asList(response);
    }

    public CarrierAccount update(String id, Map<String, Object> params) throws EasyPostException {
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        wrappedParams.put("carrier_account", params);
        return Requestor.request(Requestor.RequestMethod.PUT, InternalUtilities.instanceURL(CarrierAccount.class, id), wrappedParams, CarrierAccount.class, this.client);
    }

    public void delete(String id) throws EasyPostException {
        Requestor.request(Requestor.RequestMethod.DELETE, InternalUtilities.instanceURL(CarrierAccount.class, id), null, CarrierAccount.class, this.client);
    }

    private static String selectCarrierAccountCreationEndpoint(String carrierAccountType) {
        if (Constants.CarrierAccountTypes.CARRIER_TYPES_WITH_CUSTOM_WORKFLOW.contains(carrierAccountType)) {
            return "%s/%s/carrier_accounts/register";
        }
        return "%s/%s/carrier_accounts";
    }
}

