/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.service;

import com.easypost.exception.EasyPostException;
import com.easypost.http.Requestor;
import com.easypost.model.Event;
import com.easypost.model.EventCollection;
import com.easypost.model.Payload;
import com.easypost.model.PayloadCollection;
import com.easypost.service.EasyPostClient;
import com.easypost.utils.InternalUtilities;
import java.util.List;
import java.util.Map;

public class EventService {
    private final EasyPostClient client;

    EventService(EasyPostClient client) {
        this.client = client;
    }

    public Event retrieve(String id) throws EasyPostException {
        return Requestor.request(Requestor.RequestMethod.GET, InternalUtilities.instanceURL(Event.class, id), null, Event.class, this.client);
    }

    public EventCollection all(Map<String, Object> params) throws EasyPostException {
        return Requestor.request(Requestor.RequestMethod.GET, InternalUtilities.classURL(Event.class), params, EventCollection.class, this.client);
    }

    public List<Payload> retrieveAllPayloads(String eventId) throws EasyPostException {
        PayloadCollection payloads = Requestor.request(Requestor.RequestMethod.GET, String.format("%s/%s", InternalUtilities.instanceURL(Event.class, eventId), "payloads"), null, PayloadCollection.class, this.client);
        return payloads.getPayloads();
    }

    public Payload retrievePayload(String eventId, String payloadId) throws EasyPostException {
        return Requestor.request(Requestor.RequestMethod.GET, String.format("%s/%s/%s", InternalUtilities.instanceURL(Event.class, eventId), "payloads", payloadId), null, Payload.class, this.client);
    }
}

