/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.utils;

import com.easypost.exception.API.EncodingError;
import java.net.URLEncoder;
import java.util.Map;

public abstract class InternalUtilities {
    public static String getEncodedURL(Map<String, String> params, String parentKey) throws EncodingError {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        try {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    result.append("&");
                }
                result.append(URLEncoder.encode(parentKey + "[" + entry.getKey() + "]", "UTF-8"));
                result.append("=");
                result.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
            }
        }
        catch (Exception e) {
            throw new EncodingError("Something went wrong during the URL encoding.");
        }
        return result.toString();
    }

    public static String instanceURL(Class<?> clazz, String id) {
        return String.format("%s/%s", InternalUtilities.classURL(clazz), id);
    }

    public static String classURL(Class<?> clazz) {
        String singleURL = InternalUtilities.singleClassURL(clazz);
        if (singleURL.charAt(singleURL.length() - 1) == 's' || singleURL.charAt(singleURL.length() - 1) == 'h') {
            return String.format("%ses", InternalUtilities.singleClassURL(clazz));
        }
        return String.format("%ss", InternalUtilities.singleClassURL(clazz));
    }

    private static String singleClassURL(Class<?> clazz) {
        return String.format("%s/%s", "%s/%s", InternalUtilities.className(clazz));
    }

    private static String className(Class<?> clazz) {
        return clazz.getSimpleName().replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase().replace("$", "");
    }
}

