/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.service;

import com.easypost.exception.EasyPostException;
import com.easypost.http.Requestor;
import com.easypost.model.Tracker;
import com.easypost.model.TrackerCollection;
import com.easypost.service.EasyPostClient;
import java.util.HashMap;
import java.util.Map;

public class TrackerService {
    private final EasyPostClient client;

    TrackerService(EasyPostClient client) {
        this.client = client;
    }

    public Tracker create(Map<String, Object> params) throws EasyPostException {
        HashMap<String, Object> wrappedParams = new HashMap<String, Object>();
        wrappedParams.put("tracker", params);
        String endpoint = "trackers";
        return Requestor.request(Requestor.RequestMethod.POST, endpoint, wrappedParams, Tracker.class, this.client);
    }

    public Tracker retrieve(String id) throws EasyPostException {
        String endpoint = "trackers/" + id;
        return Requestor.request(Requestor.RequestMethod.GET, endpoint, null, Tracker.class, this.client);
    }

    public TrackerCollection all(Map<String, Object> params) throws EasyPostException {
        String endpoint = "trackers";
        return Requestor.request(Requestor.RequestMethod.GET, endpoint, params, TrackerCollection.class, this.client);
    }

    public void createList(Map<String, Object> params) throws EasyPostException {
        HashMap<String, Object> newParams = new HashMap<String, Object>();
        newParams.put("trackers", params);
        String endpoint = "trackers/create_list";
        Requestor.request(Requestor.RequestMethod.POST, endpoint, newParams, Object.class, this.client);
    }
}

