/*
 * Decompiled with CFR 0.152.
 */
package com.easypost.model;

import com.easypost.exception.EasyPostException;
import com.easypost.model.Address;
import com.easypost.model.CarrierAccount;
import com.easypost.model.EasyPostResource;
import com.easypost.model.PickupRate;
import com.easypost.model.Rate;
import com.easypost.model.ShipmentMessage;
import com.easypost.utils.Utilities;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public final class Pickup
extends EasyPostResource {
    private String status;
    private String reference;
    private Date minDatetime;
    private Date maxDatetime;
    private Boolean isAccountAddress;
    private String instructions;
    private List<ShipmentMessage> messages;
    private String confirmation;
    private Address address;
    private List<CarrierAccount> carrierAccounts;
    private List<PickupRate> pickupRates;

    public PickupRate lowestRate() throws EasyPostException {
        return this.lowestRate(null, null);
    }

    public PickupRate lowestRate(List<String> carriers, List<String> services) throws EasyPostException {
        ArrayList<Rate> rates = new ArrayList<Rate>();
        for (PickupRate rate : this.getPickupRates()) {
            rates.add(rate);
        }
        return (PickupRate)Utilities.getLowestObjectRate(rates, carriers, services);
    }

    public PickupRate lowestRate(List<String> carriers) throws EasyPostException {
        return this.lowestRate(carriers, null);
    }

    public String getStatus() {
        return this.status;
    }

    public String getReference() {
        return this.reference;
    }

    public Date getMinDatetime() {
        return this.minDatetime;
    }

    public Date getMaxDatetime() {
        return this.maxDatetime;
    }

    public Boolean getIsAccountAddress() {
        return this.isAccountAddress;
    }

    public String getInstructions() {
        return this.instructions;
    }

    public List<ShipmentMessage> getMessages() {
        return this.messages;
    }

    public String getConfirmation() {
        return this.confirmation;
    }

    public Address getAddress() {
        return this.address;
    }

    public List<CarrierAccount> getCarrierAccounts() {
        return this.carrierAccounts;
    }

    public List<PickupRate> getPickupRates() {
        return this.pickupRates;
    }
}

